/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.research.type;

import com.google.gson.annotations.Expose;
import iskallia.vault.research.Restrictions;
import iskallia.vault.research.type.Research;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class CustomResearch
extends Research {
    @Expose
    protected Map<String, Restrictions> itemRestrictions = new HashMap<String, Restrictions>();
    @Expose
    protected Map<String, Restrictions> blockRestrictions = new HashMap<String, Restrictions>();
    @Expose
    protected Map<String, Restrictions> entityRestrictions = new HashMap<String, Restrictions>();

    public CustomResearch(String name, int cost) {
        super(name, cost);
    }

    public Map<String, Restrictions> getItemRestrictions() {
        return this.itemRestrictions;
    }

    public Map<String, Restrictions> getBlockRestrictions() {
        return this.blockRestrictions;
    }

    public Map<String, Restrictions> getEntityRestrictions() {
        return this.entityRestrictions;
    }

    @Override
    public boolean restricts(Item item, Restrictions.Type restrictionType) {
        ResourceLocation registryName = item.getRegistryName();
        if (registryName == null) {
            return false;
        }
        String sid = registryName.m_135827_() + ":" + registryName.m_135815_();
        Restrictions restrictions = this.itemRestrictions.get(sid);
        if (restrictions == null) {
            return false;
        }
        return restrictions.restricts(restrictionType);
    }

    @Override
    public boolean restricts(Block block, Restrictions.Type restrictionType) {
        ResourceLocation registryName = block.getRegistryName();
        if (registryName == null) {
            return false;
        }
        String sid = registryName.m_135827_() + ":" + registryName.m_135815_();
        Restrictions restrictions = this.blockRestrictions.get(sid);
        if (restrictions == null) {
            return false;
        }
        return restrictions.restricts(restrictionType);
    }

    @Override
    public boolean restricts(EntityType<?> entityType, Restrictions.Type restrictionType) {
        ResourceLocation registryName = entityType.getRegistryName();
        if (registryName == null) {
            return false;
        }
        String sid = registryName.m_135827_() + ":" + registryName.m_135815_();
        Restrictions restrictions = this.entityRestrictions.get(sid);
        if (restrictions == null) {
            return false;
        }
        return restrictions.restricts(restrictionType);
    }
}

