/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message.relic;

import iskallia.vault.container.RelicPedestalContainer;
import iskallia.vault.util.EntityHelper;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record SelectRelicMessage(ResourceLocation relicId) {
    public static void encode(SelectRelicMessage message, FriendlyByteBuf buffer) {
        buffer.m_130085_(message.relicId);
    }

    public static SelectRelicMessage decode(FriendlyByteBuf buffer) {
        ResourceLocation modelId = buffer.m_130281_();
        return new SelectRelicMessage(modelId);
    }

    public static void handle(SelectRelicMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            AbstractContainerMenu patt1255$temp = sender.f_36096_;
            if (patt1255$temp instanceof RelicPedestalContainer) {
                RelicPedestalContainer container = (RelicPedestalContainer)patt1255$temp;
                container.getInternalInventory().forEachInput(relativeIndex -> {
                    ItemStack itemStack = container.getInternalInventory().m_8020_((int)relativeIndex);
                    if (!itemStack.m_41619_()) {
                        EntityHelper.giveItem((Player)sender, itemStack);
                    }
                });
                container.selectRelic(message.relicId);
            }
        });
        context.setPacketHandled(true);
    }
}

