/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message.bounty;

import iskallia.vault.bounty.Bounty;
import iskallia.vault.container.BountyContainer;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.bounty.ClientboundRefreshBountiesMessage;
import iskallia.vault.world.data.BountyData;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record ServerboundRerollMessage(UUID bountyId) {
    public static void encode(ServerboundRerollMessage message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.bountyId);
    }

    public static ServerboundRerollMessage decode(FriendlyByteBuf buffer) {
        UUID bountyId = buffer.m_130259_();
        return new ServerboundRerollMessage(bountyId);
    }

    public static void handle(ServerboundRerollMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer == null) {
                return;
            }
            UUID playerId = serverPlayer.m_142081_();
            AbstractContainerMenu patt1403$temp = serverPlayer.f_36096_;
            if (patt1403$temp instanceof BountyContainer) {
                BountyContainer container = (BountyContainer)patt1403$temp;
                Optional<Bounty> bounty = BountyData.get().getAllBountiesFor(serverPlayer.m_142081_()).findById(message.bountyId);
                if (bounty.isPresent()) {
                    ItemStack bronze = container.getBronzeSlot().m_7993_();
                    int cost = ModConfigs.BOUNTY_CONFIG.getCost(container.getVaultLevel(), bounty.get().getExpiration() - Instant.now().toEpochMilli());
                    bronze.m_41774_(cost);
                    container.getBronzeSlot().m_5852_(bronze);
                    BountyData.get().reroll(serverPlayer, message.bountyId);
                    ModNetwork.CHANNEL.sendTo((Object)new ClientboundRefreshBountiesMessage(BountyData.get().getAllActiveFor(playerId), BountyData.get().getAllAvailableFor(playerId), BountyData.get().getAllCompletedFor(playerId)), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

