/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message.bounty;

import iskallia.vault.bounty.BountyList;
import iskallia.vault.container.BountyContainer;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.bounty.ClientboundRefreshBountiesMessage;
import iskallia.vault.world.data.BountyData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record ServerboundClaimRewardMessage(UUID bountyId) {
    public static void encode(ServerboundClaimRewardMessage message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.bountyId);
    }

    public static ServerboundClaimRewardMessage decode(FriendlyByteBuf buffer) {
        UUID bountyId = buffer.m_130259_();
        return new ServerboundClaimRewardMessage(bountyId);
    }

    public static void handle(ServerboundClaimRewardMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer == null) {
                return;
            }
            UUID playerId = serverPlayer.m_142081_();
            BountyData.get().complete(serverPlayer, message.bountyId);
            AbstractContainerMenu patt1368$temp = serverPlayer.f_36096_;
            if (patt1368$temp instanceof BountyContainer) {
                BountyContainer container = (BountyContainer)patt1368$temp;
                container.replaceActive(new BountyList());
                ModNetwork.CHANNEL.sendTo((Object)new ClientboundRefreshBountiesMessage(BountyData.get().getAllActiveFor(playerId), BountyData.get().getAllAvailableFor(playerId), BountyData.get().getAllCompletedFor(playerId)), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        context.setPacketHandled(true);
    }
}

