/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message.bounty;

import iskallia.vault.container.BountyContainer;
import iskallia.vault.world.data.BountyData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public record ServerboundAbandonBountyMessage(UUID bountyId) {
    public static void encode(ServerboundAbandonBountyMessage message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.bountyId);
    }

    public static ServerboundAbandonBountyMessage decode(FriendlyByteBuf buffer) {
        UUID bountyId = buffer.m_130259_();
        return new ServerboundAbandonBountyMessage(bountyId);
    }

    public static void handle(ServerboundAbandonBountyMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer == null) {
                return;
            }
            BountyData.get().abandon(serverPlayer.m_142081_(), message.bountyId);
            AbstractContainerMenu patt1203$temp = serverPlayer.f_36096_;
            if (patt1203$temp instanceof BountyContainer) {
                BountyContainer container = (BountyContainer)patt1203$temp;
                container.replaceComplete(BountyData.get().getAllCompletedFor(serverPlayer.m_142081_()));
                container.m_38946_();
            }
        });
        context.setPacketHandled(true);
    }
}

