/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message.bounty;

import iskallia.vault.bounty.BountyList;
import iskallia.vault.client.gui.screen.bounty.BountyScreen;
import iskallia.vault.container.BountyContainer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public record ClientboundRefreshBountiesMessage(BountyList active, BountyList available, BountyList complete) {
    public static void encode(ClientboundRefreshBountiesMessage message, FriendlyByteBuf buffer) {
        buffer.m_130079_(message.active.serializeNBT());
        buffer.m_130079_(message.available.serializeNBT());
        buffer.m_130079_(message.complete.serializeNBT());
    }

    public static ClientboundRefreshBountiesMessage decode(FriendlyByteBuf buffer) {
        BountyList active = new BountyList(buffer.m_130260_());
        BountyList available = new BountyList(buffer.m_130260_());
        BountyList complete = new BountyList(buffer.m_130260_());
        return new ClientboundRefreshBountiesMessage(active, available, complete);
    }

    public static void handle(ClientboundRefreshBountiesMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        AbstractContainerMenu containerMenu;
        NetworkEvent.Context context = contextSupplier.get();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (player != null && (containerMenu = player.f_36096_) instanceof BountyContainer) {
            BountyContainer container = (BountyContainer)containerMenu;
            container.replaceActive(message.active);
            container.replaceAvailable(message.available);
            container.replaceComplete(message.complete);
            container.m_38946_();
            if (screen instanceof BountyScreen) {
                BountyScreen bountyScreen = (BountyScreen)screen;
                bountyScreen.getBountyTableElement().refreshBountySelection();
            }
        }
        context.setPacketHandled(true);
    }
}

