/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message.bounty;

import iskallia.vault.bounty.Bounty;
import iskallia.vault.client.gui.screen.bounty.BountyProgressScreen;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public record ClientboundBountyProgressMessage(Bounty active) {
    public static void encode(ClientboundBountyProgressMessage message, FriendlyByteBuf buffer) {
        if (message.active != null) {
            buffer.m_130079_(message.active.serializeNBT());
        }
    }

    public static ClientboundBountyProgressMessage decode(FriendlyByteBuf buffer) {
        try {
            CompoundTag tag = buffer.m_130260_();
            Bounty active = new Bounty(tag);
            return new ClientboundBountyProgressMessage(active);
        }
        catch (Exception ex) {
            return new ClientboundBountyProgressMessage(null);
        }
    }

    public static void handle(ClientboundBountyProgressMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientboundBountyProgressMessage.openScreen(message.active));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openScreen(Bounty active) {
        Minecraft.m_91087_().m_91152_((Screen)new BountyProgressScreen(active));
    }
}

