/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.sync.SyncMode;
import iskallia.vault.core.data.sync.context.ClientSyncContext;
import iskallia.vault.core.data.sync.context.SyncContext;
import iskallia.vault.core.event.ClientEvents;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class VaultMessage {

    public static class Unload {
        private final UUID id;

        public Unload(Vault vault) {
            this.id = vault.get(Vault.ID);
        }

        public Unload(FriendlyByteBuf buf) {
            this.id = buf.m_130259_();
        }

        public static void encode(Unload message, FriendlyByteBuf buffer) {
            buffer.m_130077_(message.id);
        }

        public static Unload decode(FriendlyByteBuf buffer) {
            return new Unload(buffer);
        }

        public static void handle(Unload message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (message.id.equals(ClientVaults.ACTIVE.get(Vault.ID))) {
                    ClientVaults.ACTIVE.releaseClient();
                    ClientVaults.ACTIVE = new Vault();
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class Sync {
        private final Version version;
        private final SyncMode mode;
        private final long[] payload;

        public Sync(ServerPlayer player, Vault vault, SyncMode mode) {
            this.version = vault.get(Vault.VERSION);
            this.mode = mode;
            ClientSyncContext context = new ClientSyncContext(this.version, player.m_142081_());
            ArrayBitBuffer buffer = ArrayBitBuffer.empty();
            switch (mode) {
                case FULL: {
                    vault.write(buffer, context);
                    break;
                }
                case DIFF: {
                    vault.writeDiff(buffer, context);
                    break;
                }
                case DIFF_TREE: {
                    vault.writeDiffTree(buffer, context);
                }
            }
            this.payload = buffer.toLongArray();
        }

        public Sync(FriendlyByteBuf buf) {
            this.version = (Version)buf.m_130066_(Version.class);
            this.mode = (SyncMode)buf.m_130066_(SyncMode.class);
            this.payload = buf.m_178381_();
        }

        public Vault getUpdatedVault(Vault current) {
            ArrayBitBuffer buffer = ArrayBitBuffer.backing(this.payload, 0);
            ClientEvents.release(current);
            CommonEvents.release(current);
            current = switch (this.mode) {
                default -> throw new IncompatibleClassChangeError();
                case SyncMode.FULL -> (Vault)current.read(buffer, new SyncContext(this.version));
                case SyncMode.DIFF -> (Vault)current.readDiff(buffer, new SyncContext(this.version));
                case SyncMode.DIFF_TREE -> (Vault)current.readDiffTree(buffer, new SyncContext(this.version));
            };
            current.initClient();
            return current;
        }

        public static void encode(Sync message, FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)message.version);
            buffer.m_130068_((Enum)message.mode);
            buffer.m_130091_(message.payload);
        }

        public static Sync decode(FriendlyByteBuf buffer) {
            return new Sync(buffer);
        }

        public static void handle(Sync message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                ClientVaults.ACTIVE = message.getUpdatedVault(ClientVaults.ACTIVE);
            });
            context.setPacketHandled(true);
        }
    }
}

