/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.client.gui.screen.player.legacy.ILegacySkillTreeScreen;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class VaultLevelMessage {
    public final int vaultLevel;
    public final int vaultExp;
    public final int tnl;
    public final int unspentSkillPoints;
    public final int unspentKnowledgePoints;
    public final int unspentArchetypePoints;
    public final int unspentRegretPoints;

    public VaultLevelMessage(int vaultLevel, int vaultExp, int tnl, int unspentSkillPoints, int unspentKnowledgePoints, int unspentArchetypePoints, int unspentRegretPoints) {
        this.vaultLevel = vaultLevel;
        this.vaultExp = vaultExp;
        this.tnl = tnl;
        this.unspentSkillPoints = unspentSkillPoints;
        this.unspentKnowledgePoints = unspentKnowledgePoints;
        this.unspentArchetypePoints = unspentArchetypePoints;
        this.unspentRegretPoints = unspentRegretPoints;
    }

    public static void encode(VaultLevelMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.vaultLevel);
        buffer.writeInt(message.vaultExp);
        buffer.writeInt(message.tnl);
        buffer.writeInt(message.unspentSkillPoints);
        buffer.writeInt(message.unspentKnowledgePoints);
        buffer.writeInt(message.unspentArchetypePoints);
        buffer.writeInt(message.unspentRegretPoints);
    }

    public static VaultLevelMessage decode(FriendlyByteBuf buffer) {
        int vaultLevel = buffer.readInt();
        int vaultExp = buffer.readInt();
        int tnl = buffer.readInt();
        int unspentSkillPoints = buffer.readInt();
        int unspentKnowledgePoints = buffer.readInt();
        int unspentArchetypePoints = buffer.readInt();
        int unspentRegretPoints = buffer.readInt();
        return new VaultLevelMessage(vaultLevel, vaultExp, tnl, unspentSkillPoints, unspentKnowledgePoints, unspentArchetypePoints, unspentRegretPoints);
    }

    public static void handle(VaultLevelMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            VaultBarOverlay.vaultLevel = message.vaultLevel;
            VaultBarOverlay.vaultExp = message.vaultExp;
            VaultBarOverlay.tnl = message.tnl;
            VaultBarOverlay.unspentSkillPoints = message.unspentSkillPoints;
            VaultBarOverlay.unspentKnowledgePoints = message.unspentKnowledgePoints;
            VaultBarOverlay.unspentArchetypePoints = message.unspentArchetypePoints;
            VaultBarOverlay.unspentRegretPoints = message.unspentRegretPoints;
            VaultBarOverlay.expGainedAnimation.reset();
            VaultBarOverlay.expGainedAnimation.play();
            Screen currentScreen = Minecraft.m_91087_().f_91080_;
            if (currentScreen instanceof ILegacySkillTreeScreen) {
                ILegacySkillTreeScreen skillTreeScreen = (ILegacySkillTreeScreen)currentScreen;
                skillTreeScreen.update();
            }
        });
        context.setPacketHandled(true);
    }
}

