/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.vault.goal.VaultGoalData;
import iskallia.vault.network.message.base.OpcodeMessage;
import iskallia.vault.world.vault.logic.objective.LegacyScavengerHuntObjective;
import iskallia.vault.world.vault.logic.objective.TreasureHuntObjective;
import iskallia.vault.world.vault.logic.objective.VaultModifierVotingSession;
import iskallia.vault.world.vault.logic.objective.architect.VotingSession;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.network.NetworkEvent;

public class VaultGoalMessage
extends OpcodeMessage<VaultGoal> {
    private VaultGoalMessage() {
    }

    public static void encode(VaultGoalMessage message, FriendlyByteBuf buffer) {
        message.encodeSelf(message, buffer);
    }

    public static VaultGoalMessage decode(FriendlyByteBuf buffer) {
        VaultGoalMessage message = new VaultGoalMessage();
        message.decodeSelf(buffer, VaultGoal.class);
        return message;
    }

    public static void handle(VaultGoalMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> VaultGoalData.create(message));
        context.setPacketHandled(true);
    }

    public static VaultGoalMessage obeliskGoal(int touched, int max) {
        MutableComponent text = new TextComponent("Obelisks").m_130940_(ChatFormatting.BOLD);
        return VaultGoalMessage.composeMessage(new VaultGoalMessage(), VaultGoal.OBELISK_GOAL, arg_0 -> VaultGoalMessage.lambda$obeliskGoal$1((Component)text, touched, max, arg_0));
    }

    public static VaultGoalMessage killBossGoal() {
        MutableComponent text = new TextComponent("Boss Battle").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.GREEN);
        return VaultGoalMessage.composeMessage(new VaultGoalMessage(), VaultGoal.OBELISK_MESSAGE, arg_0 -> VaultGoalMessage.lambda$killBossGoal$2((Component)text, arg_0));
    }

    public static VaultGoalMessage scavengerHunt(List<LegacyScavengerHuntObjective.ItemSubmission> activeSubmissions) {
        return VaultGoalMessage.composeMessage(new VaultGoalMessage(), VaultGoal.SCAVENGER_GOAL, payload -> {
            ListTag list = new ListTag();
            for (LegacyScavengerHuntObjective.ItemSubmission submission : activeSubmissions) {
                list.add((Object)submission.serialize());
            }
            payload.m_128365_("scavengerItems", (Tag)list);
        });
    }

    public static VaultGoalMessage treasureHunt(List<TreasureHuntObjective.ItemSubmission> activeSubmissions) {
        return VaultGoalMessage.composeMessage(new VaultGoalMessage(), VaultGoal.SCAVENGER_GOAL, payload -> {
            ListTag list = new ListTag();
            for (TreasureHuntObjective.ItemSubmission submission : activeSubmissions) {
                list.add((Object)submission.serialize());
            }
            payload.m_128365_("scavengerItems", (Tag)list);
        });
    }

    public static VaultGoalMessage architectEvent(float completedPercent, int ticksUntilNextVote, int totalTicksUntilNextVote, @Nullable VotingSession activeVotingSession) {
        return VaultGoalMessage.composeMessage(new VaultGoalMessage(), VaultGoal.ARCHITECT_GOAL, payload -> {
            payload.m_128350_("completedPercent", completedPercent);
            payload.m_128405_("ticksUntilNextVote", ticksUntilNextVote);
            payload.m_128405_("totalTicksUntilNextVote", totalTicksUntilNextVote);
            if (activeVotingSession != null) {
                payload.m_128365_("votingSession", (Tag)activeVotingSession.serialize());
            }
        });
    }

    public static VaultGoalMessage ancientsHunt(int totalAncients, int foundAncients) {
        return VaultGoalMessage.composeMessage(new VaultGoalMessage(), VaultGoal.ANCIENTS_GOAL, payload -> {
            payload.m_128405_("total", totalAncients);
            payload.m_128405_("found", foundAncients);
        });
    }

    public static VaultGoalMessage raidChallenge(int wave, int totalWaves, int aliveMobs, int totalMobs, int tickWaveDelay, int completed, int target, List<Component> positiveModifiers, List<Component> negativeModifiers, VaultModifierVotingSession modifierVotingSession) {
        return VaultGoalMessage.composeMessage(new VaultGoalMessage(), VaultGoal.RAID_GOAL, payload -> {
            payload.m_128405_("wave", wave);
            payload.m_128405_("totalWaves", totalWaves);
            payload.m_128405_("aliveMobs", aliveMobs);
            payload.m_128405_("totalMobs", totalMobs);
            payload.m_128405_("tickWaveDelay", tickWaveDelay);
            payload.m_128405_("completedRaids", completed);
            payload.m_128405_("targetRaids", target);
            ListTag positives = new ListTag();
            positiveModifiers.forEach(modifier -> positives.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)modifier))));
            payload.m_128365_("positives", (Tag)positives);
            ListTag negatives = new ListTag();
            negativeModifiers.forEach(modifier -> negatives.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)modifier))));
            payload.m_128365_("negatives", (Tag)negatives);
            if (modifierVotingSession != null) {
                payload.m_128365_("votingSession", (Tag)modifierVotingSession.serialize());
            }
        });
    }

    public static VaultGoalMessage cakeHunt(int totalCakes, int foundCakes) {
        return VaultGoalMessage.composeMessage(new VaultGoalMessage(), VaultGoal.CAKE_HUNT_GOAL, payload -> {
            payload.m_128405_("total", totalCakes);
            payload.m_128405_("found", foundCakes);
        });
    }

    public static VaultGoalMessage clear() {
        return VaultGoalMessage.composeMessage(new VaultGoalMessage(), VaultGoal.CLEAR, payload -> {});
    }

    private static /* synthetic */ void lambda$killBossGoal$2(Component text, CompoundTag payload) {
        payload.m_128359_("Message", Component.Serializer.m_130703_((Component)text));
    }

    private static /* synthetic */ void lambda$obeliskGoal$1(Component text, int touched, int max, CompoundTag payload) {
        payload.m_128359_("Message", Component.Serializer.m_130703_((Component)text));
        payload.m_128405_("TouchedObelisks", touched);
        payload.m_128405_("MaxObelisks", max);
    }

    public static enum VaultGoal {
        OBELISK_GOAL,
        OBELISK_MESSAGE,
        SCAVENGER_GOAL,
        ARCHITECT_GOAL,
        ANCIENTS_GOAL,
        RAID_GOAL,
        CAKE_HUNT_GOAL,
        CLEAR;

    }
}

