/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.block.entity.VaultForgeTileEntity;
import iskallia.vault.container.VaultForgeContainer;
import iskallia.vault.gear.crafting.VaultForgeHelper;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ForgeParticleMessage;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class VaultForgeRequestCraftMessage {
    private final ResourceLocation recipe;

    public VaultForgeRequestCraftMessage(ResourceLocation recipe) {
        this.recipe = recipe;
    }

    public static void encode(VaultForgeRequestCraftMessage message, FriendlyByteBuf buffer) {
        buffer.m_130085_(message.recipe);
    }

    public static VaultForgeRequestCraftMessage decode(FriendlyByteBuf buffer) {
        return new VaultForgeRequestCraftMessage(buffer.m_130281_());
    }

    public static void handle(VaultForgeRequestCraftMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            AbstractContainerMenu patt1556$temp;
            ServerPlayer requester = context.getSender();
            if (requester == null || !((patt1556$temp = requester.f_36096_) instanceof VaultForgeContainer)) {
                return;
            }
            VaultForgeContainer container = (VaultForgeContainer)patt1556$temp;
            if (!container.getResultSlot().m_7993_().m_41619_()) {
                return;
            }
            VaultForgeRecipe recipe = ModConfigs.VAULT_GEAR_RECIPES_CONFIG.getRecipe(message.recipe);
            if (recipe == null || !recipe.canCraft((Player)requester)) {
                return;
            }
            Inventory playerInventory = requester.m_150109_();
            VaultForgeTileEntity tile = container.getTileEntity();
            if (VaultForgeHelper.consumeInputs(recipe.getInputs(), playerInventory, tile, true) && VaultForgeHelper.consumeInputs(recipe.getInputs(), playerInventory, tile, false)) {
                container.getResultSlot().m_5852_(recipe.createOutput(requester));
                requester.f_19853_.m_46796_(1030, tile.m_58899_(), 0);
                container.m_38946_();
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ForgeParticleMessage(tile.m_58899_()));
            }
        });
        context.setPacketHandled(true);
    }
}

