/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.container.VaultArtisanStationContainer;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.gear.modification.GearModificationAction;
import iskallia.vault.gear.modification.GearModificationRegistry;
import iskallia.vault.init.ModSounds;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class VaultArtisanRequestModificationMessage {
    private final ResourceLocation modification;

    public VaultArtisanRequestModificationMessage(ResourceLocation modification) {
        this.modification = modification;
    }

    public static void encode(VaultArtisanRequestModificationMessage message, FriendlyByteBuf buffer) {
        buffer.m_130085_(message.modification);
    }

    public static VaultArtisanRequestModificationMessage decode(FriendlyByteBuf buffer) {
        return new VaultArtisanRequestModificationMessage(buffer.m_130281_());
    }

    public static void handle(VaultArtisanRequestModificationMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            AbstractContainerMenu patt1601$temp;
            ServerPlayer requester = context.getSender();
            if (requester == null || !((patt1601$temp = requester.f_36096_) instanceof VaultArtisanStationContainer)) {
                return;
            }
            VaultArtisanStationContainer container = (VaultArtisanStationContainer)patt1601$temp;
            GearModification modification = GearModificationRegistry.getModification(message.modification);
            if (modification == null) {
                return;
            }
            GearModificationAction action = container.getModificationAction(modification);
            if (action == null) {
                return;
            }
            if (action.canApply(container, (Player)requester)) {
                action.apply(container, requester);
                ServerLevel level = requester.m_183503_();
                level.m_5594_(null, container.getTilePos(), ModSounds.ARTISAN_SMITHING, SoundSource.BLOCKS, 0.2f, level.f_46441_.nextFloat() * 0.1f + 0.9f);
            }
        });
        context.setPacketHandled(true);
    }
}

