/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import io.netty.buffer.ByteBuf;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.util.NetcodeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SyncOverSizedContentMessage {
    private final int containerId;
    private final int stateId;
    private final List<OverSizedItemStack> items;
    private final ItemStack carriedItem;

    public SyncOverSizedContentMessage(int containerId, int stateId, List<ItemStack> items, ItemStack carriedItem) {
        this.containerId = containerId;
        this.stateId = stateId;
        this.items = items.stream().map(OverSizedItemStack::of).toList();
        this.carriedItem = carriedItem.m_41777_();
    }

    public SyncOverSizedContentMessage(FriendlyByteBuf buf) {
        this.containerId = buf.readInt();
        this.stateId = buf.readInt();
        this.items = NetcodeUtils.readCollection((ByteBuf)buf, ArrayList::new, buffer -> OverSizedItemStack.read(buf));
        this.carriedItem = buf.m_130267_();
    }

    public static void encode(SyncOverSizedContentMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.containerId);
        buffer.writeInt(message.stateId);
        NetcodeUtils.writeCollection((ByteBuf)buffer, message.items, (stack, buf) -> stack.write(buffer));
        buffer.m_130055_(message.carriedItem);
    }

    public static SyncOverSizedContentMessage decode(FriendlyByteBuf buffer) {
        return new SyncOverSizedContentMessage(buffer);
    }

    public static void handle(SyncOverSizedContentMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SyncOverSizedContentMessage.handleContent(message));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleContent(SyncOverSizedContentMessage message) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (message.containerId == player.f_36096_.f_38840_) {
            List<ItemStack> contents = message.items.stream().map(OverSizedItemStack::overSizedStack).toList();
            player.f_36096_.m_182410_(message.stateId, contents, message.carriedItem);
        }
    }
}

