/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.container.inventory.ShardTradeContainer;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.ItemShardPouch;
import iskallia.vault.item.gear.DataTransferItem;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.world.data.PlayerBlackMarketData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ShardTradeTradeMessage {
    private final int tradeIndex;
    private final UUID uuid;
    private final boolean shift;

    public ShardTradeTradeMessage(int tradeIndex, boolean shift, UUID uuid) {
        this.tradeIndex = tradeIndex;
        this.shift = shift;
        this.uuid = uuid;
    }

    public boolean isRandom() {
        return this.tradeIndex == -1;
    }

    public static void encode(ShardTradeTradeMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.tradeIndex);
        buffer.writeBoolean(message.shift);
        buffer.m_130077_(message.uuid);
    }

    public static ShardTradeTradeMessage decode(FriendlyByteBuf buffer) {
        return new ShardTradeTradeMessage(buffer.readInt(), buffer.readBoolean(), buffer.m_130259_());
    }

    public static void handle(ShardTradeTradeMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ItemStack held;
            ItemStack resultStack;
            int shardCost;
            AbstractContainerMenu patt1865$temp;
            ServerPlayer sender = context.getSender();
            if (sender == null || !((patt1865$temp = sender.f_36096_) instanceof ShardTradeContainer)) {
                return;
            }
            ShardTradeContainer tradeContainer = (ShardTradeContainer)patt1865$temp;
            PlayerBlackMarketData tradeData = PlayerBlackMarketData.get(sender.m_183503_());
            int shardCount = ItemShardPouch.getShardCount(sender.m_150109_());
            if (message.isRandom()) {
                if (shardCount < ModConfigs.SOUL_SHARD.getShardTradePrice()) {
                    return;
                }
                shardCost = ModConfigs.SOUL_SHARD.getShardTradePrice();
                resultStack = ModConfigs.SOUL_SHARD.getRandomTrade().getItem().m_41777_();
            } else {
                PlayerBlackMarketData.BlackMarket.SelectedTrade trade = tradeData.getBlackMarket(message.uuid).getTrades().get(message.tradeIndex);
                if (trade == null || shardCount < trade.getShardCost()) {
                    return;
                }
                shardCost = trade.getShardCost();
                resultStack = trade.getStack().m_41777_();
            }
            if (resultStack.m_41619_()) {
                return;
            }
            Item patt3110$temp = (resultStack = DataTransferItem.doConvertStack(resultStack)).m_41720_();
            if (patt3110$temp instanceof VaultGearItem) {
                VaultGearItem gearItem = (VaultGearItem)patt3110$temp;
                gearItem.setPlayerLevel(resultStack, (Player)sender);
                VaultGearHelper.initializeGearRollType(resultStack, sender);
            }
            if (!ItemShardPouch.reduceShardAmount(sender.m_150109_(), shardCost, true)) {
                return;
            }
            if (message.shift ? !MiscUtils.canMergeIntoInventory((Container)sender.m_150109_(), resultStack) : !(held = tradeContainer.m_142621_()).m_41619_()) {
                return;
            }
            if (ItemShardPouch.reduceShardAmount(sender.m_150109_(), shardCost, false)) {
                if (!message.isRandom()) {
                    tradeData.getBlackMarket(message.uuid).useTrade(message.tradeIndex);
                }
                if (message.shift) {
                    MiscUtils.mergeIntoInventory((Container)sender.m_150109_(), resultStack);
                } else {
                    held = tradeContainer.m_142621_();
                    if (held.m_41619_()) {
                        tradeContainer.m_142503_(resultStack);
                    } else {
                        held.m_41769_(resultStack.m_41613_());
                    }
                }
                tradeContainer.m_38946_();
            }
            sender.f_19853_.m_5594_(null, sender.m_142538_(), ModSounds.VAULT_CHEST_RARE_OPEN, SoundSource.PLAYERS, 1.0f, 0.5f);
            tradeData.getBlackMarket((Player)sender).syncToClient(sender.f_8924_);
        });
        context.setPacketHandled(true);
    }
}

