/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.skill.ability.AbilityTree;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundAbilityKeyMessage {
    private final Opcode opcode;

    private ServerboundAbilityKeyMessage(Opcode opcode) {
        this.opcode = opcode;
    }

    public static void send(Opcode opcode) {
        ModNetwork.CHANNEL.sendToServer((Object)new ServerboundAbilityKeyMessage(opcode));
    }

    public static void encode(ServerboundAbilityKeyMessage message, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)message.opcode);
    }

    public static ServerboundAbilityKeyMessage decode(FriendlyByteBuf buffer) {
        return new ServerboundAbilityKeyMessage((Opcode)buffer.m_130066_(Opcode.class));
    }

    public static void handle(ServerboundAbilityKeyMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            PlayerAbilitiesData abilitiesData = PlayerAbilitiesData.get((ServerLevel)sender.f_19853_);
            AbilityTree abilityTree = abilitiesData.getAbilities((Player)sender);
            switch (message.opcode) {
                case KeyUp: {
                    abilityTree.keyUp(sender.f_8924_);
                    break;
                }
                case KeyDown: {
                    abilityTree.keyDown(sender.f_8924_);
                    break;
                }
                case ScrollUp: {
                    abilityTree.scrollUp(sender.f_8924_);
                    break;
                }
                case ScrollDown: {
                    abilityTree.scrollDown(sender.f_8924_);
                    break;
                }
                case CancelKeyDown: {
                    abilityTree.cancelKeyDown(sender.f_8924_);
                }
            }
        });
        context.setPacketHandled(true);
    }

    public static enum Opcode {
        KeyUp,
        KeyDown,
        ScrollUp,
        ScrollDown,
        CancelKeyDown;

    }
}

