/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.research.ResearchTree;
import iskallia.vault.research.type.Research;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.world.data.DiscoveredModelsData;
import iskallia.vault.world.data.PlayerResearchesData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;

public class ResearchMessage {
    public String researchName;

    public ResearchMessage() {
    }

    public ResearchMessage(String researchName) {
        this.researchName = researchName;
    }

    public static void encode(ResearchMessage message, FriendlyByteBuf buffer) {
        buffer.m_130072_(message.researchName, Short.MAX_VALUE);
    }

    public static ResearchMessage decode(FriendlyByteBuf buffer) {
        ResearchMessage message = new ResearchMessage();
        message.researchName = buffer.m_130136_(Short.MAX_VALUE);
        return message;
    }

    public static void handle(ResearchMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            Research research = ModConfigs.RESEARCHES.getByName(message.researchName);
            if (research == null) {
                return;
            }
            PlayerVaultStatsData statsData = PlayerVaultStatsData.get((ServerLevel)sender.f_19853_);
            PlayerResearchesData researchesData = PlayerResearchesData.get((ServerLevel)sender.f_19853_);
            ResearchTree researchTree = researchesData.getResearches((Player)sender);
            if (researchTree.isResearched(research)) {
                return;
            }
            int researchCost = researchTree.getResearchCost(research);
            if (ModConfigs.SKILL_GATES.getGates().isLocked(research.getName(), researchTree)) {
                return;
            }
            PlayerVaultStats stats = statsData.getVaultStats((Player)sender);
            int currentPoints = stats.getUnspentKnowledgePoints();
            if (currentPoints >= researchCost) {
                researchesData.research(sender, research);
                List<String> discoversModels = research.getDiscoversModels();
                statsData.spendKnowledgePoints(sender, researchCost);
                if (discoversModels != null && !discoversModels.isEmpty()) {
                    DiscoveredModelsData discoveredModelsData = DiscoveredModelsData.get(sender.f_8924_);
                    discoversModels.stream().map(ResourceLocation::new).forEach(modelId -> ModDynamicModels.REGISTRIES.getModelAndAssociatedItem((ResourceLocation)modelId).ifPresent(pair -> {
                        DynamicModel gearModel = (DynamicModel)pair.getFirst();
                        Item associatedItem = (Item)pair.getSecond();
                        discoveredModelsData.discoverModelAndBroadcast(associatedItem, gearModel.getId(), (Player)sender);
                    }));
                }
            }
        });
        context.setPacketHandled(true);
    }
}

