/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.block.entity.CryoChamberTileEntity;
import iskallia.vault.block.entity.LootStatueTileEntity;
import iskallia.vault.util.RenameType;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class RenameUIMessage {
    public RenameType renameType;
    public CompoundTag payload;

    public static void encode(RenameUIMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.renameType.ordinal());
        buffer.m_130079_(message.payload);
    }

    public static RenameUIMessage decode(FriendlyByteBuf buffer) {
        RenameUIMessage message = new RenameUIMessage();
        message.renameType = RenameType.values()[buffer.readInt()];
        message.payload = buffer.m_130260_();
        return message;
    }

    public static void handle(RenameUIMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            CompoundTag data = message.payload.m_128469_("Data");
            ServerPlayer sender = context.getSender();
            switch (message.renameType) {
                case PLAYER_STATUE: {
                    BlockPos statuePos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("Pos"));
                    BlockEntity te = sender.m_20193_().m_7702_(statuePos);
                    if (!(te instanceof LootStatueTileEntity)) break;
                    LootStatueTileEntity statue = (LootStatueTileEntity)te;
                    statue.getSkin().updateSkin(data.m_128461_("PlayerNickname"));
                    statue.sendUpdates();
                    break;
                }
                case VAULT_CRYSTAL: {
                    sender.m_150109_().f_35974_.set(sender.m_150109_().f_35977_, (Object)ItemStack.m_41712_((CompoundTag)data));
                    break;
                }
                case CRYO_CHAMBER: {
                    BlockPos pos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("BlockPos"));
                    String name = data.m_128461_("EternalName");
                    BlockEntity te = sender.m_20193_().m_7702_(pos);
                    if (!(te instanceof CryoChamberTileEntity)) break;
                    CryoChamberTileEntity chamber = (CryoChamberTileEntity)te;
                    chamber.renameEternal(name);
                    chamber.getSkin().updateSkin(name);
                    chamber.sendUpdates();
                }
            }
        });
        context.setPacketHandled(true);
    }

    public static RenameUIMessage updateName(RenameType type, CompoundTag nbt) {
        RenameUIMessage message = new RenameUIMessage();
        message.renameType = type;
        message.payload = nbt;
        return message;
    }
}

