/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.network.message.RaffleClientMessage;
import iskallia.vault.util.data.WeightedList;
import iskallia.vault.world.data.PlayerAliasData;
import iskallia.vault.world.data.PlayerStatsData;
import iskallia.vault.world.data.StreamData;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class RaffleServerMessage {
    public Opcode opcode;
    public CompoundTag payload;

    public static void encode(RaffleServerMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.opcode.ordinal());
        buffer.m_130079_(message.payload);
    }

    public static RaffleServerMessage decode(FriendlyByteBuf buffer) {
        RaffleServerMessage message = new RaffleServerMessage();
        message.opcode = Opcode.values()[buffer.readInt()];
        message.payload = buffer.m_130260_();
        return message;
    }

    public static void handle(RaffleServerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender;
            if (message.opcode == Opcode.REQUEST_RAFFLE) {
                ServerPlayer sender2 = context.getSender();
                if (sender2 == null) {
                    return;
                }
                WeightedList<String> occupants = RaffleServerMessage.getOccupants(sender2);
                if (occupants.size() < 5) {
                    TextComponent text = new TextComponent("Not enough people for Raffle");
                    text.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)-26266)));
                    sender2.m_5661_((Component)text, true);
                } else {
                    String winner = occupants.getRandom(sender2.f_19853_.f_46441_);
                    ModNetwork.CHANNEL.sendTo((Object)RaffleClientMessage.openUI(occupants, winner), sender2.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
            } else if (message.opcode == Opcode.DONE_ANIMATING && (sender = context.getSender()) != null) {
                String winner = message.payload.m_128461_("Winner");
                PlayerStatsData.get().onRaffleCompleted(sender.m_142081_(), RaffleServerMessage.getOccupants(sender), winner);
                StreamData streamData = StreamData.get(sender.m_183503_());
                streamData.resetDonos(sender.m_20194_(), sender.m_142081_());
                RaffleServerMessage.dropRewards(sender, winner);
            }
        });
        context.setPacketHandled(true);
    }

    public static WeightedList<String> getOccupants(ServerPlayer sender) {
        StreamData streamData = StreamData.get(sender.m_183503_());
        StreamData.Donations donations = streamData.getDonations(sender.m_142081_());
        return donations.toWeightedList();
    }

    public static void dropRewards(ServerPlayer sender, String winner) {
        winner = PlayerAliasData.applyAlias(sender, winner);
        ItemStack vaultCrystal = VaultCrystalItem.getCrystalWithBoss(winner);
        sender.m_7197_(vaultCrystal, false, false);
    }

    public static RaffleServerMessage requestRaffle() {
        RaffleServerMessage message = new RaffleServerMessage();
        message.opcode = Opcode.REQUEST_RAFFLE;
        message.payload = new CompoundTag();
        return message;
    }

    public static RaffleServerMessage animationDone(String winner) {
        RaffleServerMessage message = new RaffleServerMessage();
        message.opcode = Opcode.DONE_ANIMATING;
        message.payload = new CompoundTag();
        message.payload.m_128359_("Winner", winner);
        return message;
    }

    public static enum Opcode {
        REQUEST_RAFFLE,
        DONE_ANIMATING;

    }
}

