/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.gui.screen.RaffleScreen;
import iskallia.vault.util.data.WeightedList;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class RaffleClientMessage {
    public Opcode opcode;
    public CompoundTag payload;

    public static void encode(RaffleClientMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.opcode.ordinal());
        buffer.m_130079_(message.payload);
    }

    public static RaffleClientMessage decode(FriendlyByteBuf buffer) {
        RaffleClientMessage message = new RaffleClientMessage();
        message.opcode = Opcode.values()[buffer.readInt()];
        message.payload = buffer.m_130260_();
        return message;
    }

    public static void handle(RaffleClientMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (message.opcode == Opcode.OPEN_UI) {
                List<String> occupants = NBTHelper.readList(message.payload, "Occupants", StringTag.class, StringTag::m_7916_);
                String winner = message.payload.m_128461_("Winner");
                RaffleClientMessage.displayGUI(occupants, winner);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void displayGUI(List<String> occupants, String winner) {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.m_91152_((Screen)new RaffleScreen(occupants, winner));
    }

    public static RaffleClientMessage openUI(List<WeightedList.Entry<String>> occupants, String winner) {
        RaffleClientMessage message = new RaffleClientMessage();
        message.opcode = Opcode.OPEN_UI;
        message.payload = new CompoundTag();
        NBTHelper.writeCollection(message.payload, "Occupants", occupants, StringTag.class, occupant -> StringTag.m_129297_((String)((String)occupant.value)));
        message.payload.m_128359_("Winner", winner);
        return message;
    }

    public static enum Opcode {
        OPEN_UI;

    }
}

