/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.ClientProficiencyData;
import iskallia.vault.gear.crafting.ProficiencyType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ProficiencyMessage {
    private final Map<ProficiencyType, Float> proficiency;

    private ProficiencyMessage() {
        this(new HashMap<ProficiencyType, Float>());
    }

    public ProficiencyMessage(Map<ProficiencyType, Float> proficiency) {
        this.proficiency = proficiency;
    }

    public static void encode(ProficiencyMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.proficiency.size());
        message.proficiency.forEach((type, amount) -> {
            buffer.m_130068_((Enum)type);
            buffer.writeFloat(amount.floatValue());
        });
    }

    public static ProficiencyMessage decode(FriendlyByteBuf buffer) {
        ProficiencyMessage message = new ProficiencyMessage();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ProficiencyType type = (ProficiencyType)buffer.m_130066_(ProficiencyType.class);
            message.proficiency.put(type, Float.valueOf(buffer.readFloat()));
        }
        return message;
    }

    public static void handle(ProficiencyMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientProficiencyData.updateProficiencies(message.proficiency));
    }
}

