/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.ClientDamageData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PlayerDamageMultiplierMessage {
    private final float multiplier;

    public PlayerDamageMultiplierMessage(float multiplier) {
        this.multiplier = multiplier;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public static void encode(PlayerDamageMultiplierMessage message, FriendlyByteBuf buffer) {
        buffer.writeFloat(message.multiplier);
    }

    public static PlayerDamageMultiplierMessage decode(FriendlyByteBuf buffer) {
        return new PlayerDamageMultiplierMessage(buffer.readFloat());
    }

    public static void handle(PlayerDamageMultiplierMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientDamageData.receiveUpdate(message));
        context.setPacketHandled(true);
    }
}

