/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.ClientTalentData;
import iskallia.vault.skill.talent.TalentNode;
import iskallia.vault.skill.talent.TalentTree;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class KnownTalentsMessage {
    private final List<TalentNode<?>> learnedTalents;

    public KnownTalentsMessage(TalentTree talentTree) {
        this(talentTree.getLearnedNodes());
    }

    private KnownTalentsMessage(List<TalentNode<?>> learnedTalents) {
        this.learnedTalents = learnedTalents;
    }

    public List<TalentNode<?>> getLearnedTalents() {
        return this.learnedTalents;
    }

    public static void encode(KnownTalentsMessage message, FriendlyByteBuf buffer) {
        CompoundTag nbt = new CompoundTag();
        ListTag talents = new ListTag();
        message.learnedTalents.stream().map(TalentNode::serializeNBT).forEach(arg_0 -> talents.add(arg_0));
        nbt.m_128365_("LearnedTalents", (Tag)talents);
        buffer.m_130079_(nbt);
    }

    public static KnownTalentsMessage decode(FriendlyByteBuf buffer) {
        ArrayList abilities = new ArrayList();
        CompoundTag nbt = buffer.m_130260_();
        ListTag learnedTalents = nbt.m_128437_("LearnedTalents", 10);
        for (int i = 0; i < learnedTalents.size(); ++i) {
            abilities.add(new TalentNode(learnedTalents.m_128728_(i)));
        }
        return new KnownTalentsMessage(abilities);
    }

    public static void handle(KnownTalentsMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientTalentData.updateTalents(message));
        context.setPacketHandled(true);
    }
}

