/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.block.entity.CryoChamberTileEntity;
import iskallia.vault.config.EternalAuraConfig;
import iskallia.vault.container.inventory.CryochamberContainer;
import iskallia.vault.entity.eternal.EternalData;
import iskallia.vault.entity.eternal.EternalDataAccess;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.world.data.EternalsData;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class EternalInteractionMessage {
    private final Action action;
    private CompoundTag extraData = new CompoundTag();

    private EternalInteractionMessage(Action action) {
        this.action = action;
    }

    public static EternalInteractionMessage feedItem(ItemStack stack) {
        EternalInteractionMessage pkt = new EternalInteractionMessage(Action.FEED_SELECTED);
        pkt.extraData.m_128365_("stack", (Tag)stack.serializeNBT());
        return pkt;
    }

    public static EternalInteractionMessage levelUp(String attribute) {
        EternalInteractionMessage pkt = new EternalInteractionMessage(Action.LEVEL_UP);
        pkt.extraData.m_128359_("attribute", attribute);
        return pkt;
    }

    public static EternalInteractionMessage selectEffect(String effectName) {
        EternalInteractionMessage pkt = new EternalInteractionMessage(Action.SELECT_EFFECT);
        pkt.extraData.m_128359_("effectName", effectName);
        return pkt;
    }

    public static void encode(EternalInteractionMessage pkt, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)pkt.action);
        buffer.m_130079_(pkt.extraData);
    }

    public static EternalInteractionMessage decode(FriendlyByteBuf buffer) {
        EternalInteractionMessage pkt = new EternalInteractionMessage((Action)buffer.m_130066_(Action.class));
        pkt.extraData = buffer.m_130260_();
        return pkt;
    }

    public static void handle(EternalInteractionMessage pkt, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (!(player.f_36096_ instanceof CryochamberContainer)) {
                return;
            }
            CryoChamberTileEntity tile = ((CryochamberContainer)player.f_36096_).getCryoChamber((Level)player.m_183503_());
            if (tile == null) {
                return;
            }
            UUID eternalId = tile.getEternalId();
            EternalsData data = EternalsData.get(player.m_183503_());
            EternalsData.EternalGroup eternals = data.getEternals((Player)player);
            EternalData eternal = eternals.get(eternalId);
            if (eternal == null) {
                return;
            }
            switch (pkt.action) {
                case FEED_SELECTED: {
                    ItemStack activeStack = player.f_36096_.m_142621_();
                    if (activeStack.m_41619_() || !EternalInteractionMessage.canBeFed(eternal, activeStack)) {
                        return;
                    }
                    if (eternal.getLevel() < eternal.getMaxLevel()) {
                        ModConfigs.ETERNAL.getFoodExp(activeStack.m_41720_()).ifPresent(foodExp -> {
                            if (eternal.addExp((int)foodExp) && !player.m_7500_()) {
                                activeStack.m_41774_(1);
                                player.f_36096_.m_38946_();
                                player.f_19853_.m_5594_(null, tile.m_58899_(), SoundEvents.f_11912_, SoundSource.PLAYERS, 0.5f, player.f_19853_.f_46441_.nextFloat() * 0.1f + 0.9f);
                                player.f_19853_.m_5594_(null, tile.m_58899_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 0.5f, player.f_19853_.f_46441_.nextFloat() * 0.1f + 0.9f);
                            }
                        });
                    }
                    if (!eternal.isAlive() && activeStack.m_41720_().equals((Object)ModItems.LIFE_SCROLL)) {
                        eternal.setAlive(true);
                        if (!player.m_7500_()) {
                            activeStack.m_41774_(1);
                            player.f_36096_.m_38946_();
                        }
                    }
                    if (!activeStack.m_41720_().equals((Object)ModItems.AURA_SCROLL)) break;
                    eternal.shuffleSeed();
                    if (eternal.getAura() != null) {
                        eternal.setAura(null);
                    }
                    if (player.m_7500_()) break;
                    activeStack.m_41774_(1);
                    player.f_36096_.m_38946_();
                    break;
                }
                case LEVEL_UP: {
                    String attribute;
                    if (eternal.getUsedLevels() >= eternal.getMaxLevel()) {
                        return;
                    }
                    switch (attribute = pkt.extraData.m_128461_("attribute")) {
                        case "health": {
                            float added = ModConfigs.ETERNAL_ATTRIBUTES.getHealthRollRange().getRandom();
                            eternal.addAttributeValue(Attributes.f_22276_, added);
                            break;
                        }
                        case "damage": {
                            float added = ModConfigs.ETERNAL_ATTRIBUTES.getDamageRollRange().getRandom();
                            eternal.addAttributeValue(Attributes.f_22281_, added);
                            break;
                        }
                        case "movespeed": {
                            float added = ModConfigs.ETERNAL_ATTRIBUTES.getMoveSpeedRollRange().getRandom();
                            eternal.addAttributeValue(Attributes.f_22279_, added);
                        }
                    }
                    break;
                }
                case SELECT_EFFECT: {
                    String selectedEffect;
                    if (eternal.getAura() != null) {
                        return;
                    }
                    List options = ModConfigs.ETERNAL_AURAS.getRandom(eternal.getSeededRand(), 3).stream().map(EternalAuraConfig.AuraConfig::getName).collect(Collectors.toList());
                    if (!options.contains(selectedEffect = pkt.extraData.m_128461_("effectName"))) {
                        return;
                    }
                    eternal.setAura(selectedEffect);
                }
            }
        });
        context.setPacketHandled(true);
    }

    public static boolean canBeFed(EternalDataAccess eternal, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (!eternal.isAlive() && stack.m_41720_().equals((Object)ModItems.LIFE_SCROLL)) {
            return true;
        }
        if (stack.m_41720_().equals((Object)ModItems.AURA_SCROLL)) {
            return true;
        }
        return eternal.getLevel() < eternal.getMaxLevel() && ModConfigs.ETERNAL.getFoodExp(stack.m_41720_()).isPresent();
    }

    public static enum Action {
        FEED_SELECTED,
        LEVEL_UP,
        SELECT_EFFECT;

    }
}

