/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.world.VaultDifficulty;
import iskallia.vault.world.data.WorldSettings;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundUpdateDifficultyMessage {
    private final VaultDifficulty vaultDifficulty;
    private final boolean vaultDifficultyLocked;

    public ClientboundUpdateDifficultyMessage(VaultDifficulty vaultDifficulty, boolean vaultDifficultyLocked) {
        this.vaultDifficulty = vaultDifficulty;
        this.vaultDifficultyLocked = vaultDifficultyLocked;
    }

    public static void encode(ClientboundUpdateDifficultyMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.vaultDifficulty.getId());
        buffer.writeBoolean(message.vaultDifficultyLocked);
    }

    public static ClientboundUpdateDifficultyMessage decode(FriendlyByteBuf buffer) {
        return new ClientboundUpdateDifficultyMessage(VaultDifficulty.byId(buffer.readInt()), buffer.readBoolean());
    }

    public static void handle(ClientboundUpdateDifficultyMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientboundUpdateDifficultyMessage.updateDifficulty(message));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void updateDifficulty(ClientboundUpdateDifficultyMessage message) {
        WorldSettings worldSettings = WorldSettings.get((Level)Minecraft.m_91087_().f_91073_);
        worldSettings.setVaultDifficulty(message.vaultDifficulty);
        worldSettings.setVaultDifficultyLocked(message.vaultDifficultyLocked);
    }
}

