/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.AbilityTree;
import iskallia.vault.skill.ability.config.spi.AbstractAbilityConfig;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class AbilitySelectSpecializationMessage {
    private final String ability;
    @Nullable
    private final String specialization;

    public AbilitySelectSpecializationMessage(String ability, @Nullable String specialization) {
        this.ability = ability;
        this.specialization = specialization;
    }

    public static void encode(AbilitySelectSpecializationMessage message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.ability);
        buffer.writeBoolean(message.specialization != null);
        if (message.specialization != null) {
            buffer.m_130070_(message.specialization);
        }
    }

    public static AbilitySelectSpecializationMessage decode(FriendlyByteBuf buffer) {
        return new AbilitySelectSpecializationMessage(buffer.m_130136_(Short.MAX_VALUE), buffer.readBoolean() ? buffer.m_130136_(Short.MAX_VALUE) : null);
    }

    public static void handle(AbilitySelectSpecializationMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            String specialization = message.specialization;
            PlayerAbilitiesData abilitiesData = PlayerAbilitiesData.get((ServerLevel)sender.f_19853_);
            AbilityTree abilityTree = abilitiesData.getAbilities((Player)sender);
            AbilityNode<?, ?> abilityNode = abilityTree.getNodeByName(message.ability);
            if (abilityNode == null) {
                return;
            }
            PlayerVaultStatsData statsData = PlayerVaultStatsData.get((ServerLevel)sender.f_19853_);
            PlayerVaultStats stats = statsData.getVaultStats((Player)sender);
            if (specialization != null) {
                if (!abilityNode.getGroup().hasSpecialization(specialization)) {
                    return;
                }
                Object specConfig = abilityNode.getGroup().getAbilityConfig(specialization, abilityNode.getLevel());
                if (specConfig == null) {
                    return;
                }
                if (stats.getVaultLevel() < ((AbstractAbilityConfig)specConfig).getLevelRequirement()) {
                    return;
                }
            } else if (abilityNode.getSpecialization() == null) {
                return;
            }
            abilitiesData.selectSpecialization(sender, abilityNode, specialization);
        });
        context.setPacketHandled(true);
    }
}

