/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.AbilityTree;
import iskallia.vault.skill.ability.KeyBehavior;
import iskallia.vault.skill.ability.group.AbilityGroup;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class AbilityQuickselectMessage {
    private final String abilityName;

    public AbilityQuickselectMessage(String abilityName) {
        this.abilityName = abilityName;
    }

    public static void encode(AbilityQuickselectMessage pkt, FriendlyByteBuf buffer) {
        buffer.m_130070_(pkt.abilityName);
    }

    public static AbilityQuickselectMessage decode(FriendlyByteBuf buffer) {
        return new AbilityQuickselectMessage(buffer.m_130136_(Short.MAX_VALUE));
    }

    public static void handle(AbilityQuickselectMessage pkt, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            AbilityGroup<?, ?> ability = ModConfigs.ABILITIES.getAbilityGroupByName(pkt.abilityName);
            if (ability == null) {
                return;
            }
            PlayerAbilitiesData abilitiesData = PlayerAbilitiesData.get((ServerLevel)sender.f_19853_);
            AbilityTree abilityTree = abilitiesData.getAbilities((Player)sender);
            AbilityNode<?, ?> abilityNode = abilityTree.getNodeOf(ability);
            if (!abilityNode.isLearned()) {
                return;
            }
            abilityTree.quickSelectAbility(sender.f_8924_, ability.getParentName());
            if (!abilityNode.equals(abilityTree.getSelectedAbility()) || abilityNode.getKeyBehavior() != KeyBehavior.INSTANT_ON_RELEASE || abilityTree.isOnCooldown(abilityNode)) {
                return;
            }
            abilityTree.keyUp(sender.f_8924_);
        });
        context.setPacketHandled(true);
    }
}

