/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.AbilityTree;
import iskallia.vault.skill.ability.config.spi.AbstractAbilityConfig;
import iskallia.vault.skill.ability.effect.spi.core.AbstractAbility;
import iskallia.vault.skill.ability.group.AbilityGroup;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class AbilityLevelMessage {
    private final String abilityName;
    private final boolean isUpgrade;

    public AbilityLevelMessage(String abilityName, boolean isUpgrade) {
        this.abilityName = abilityName;
        this.isUpgrade = isUpgrade;
    }

    public static void encode(AbilityLevelMessage message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.abilityName);
        buffer.writeBoolean(message.isUpgrade);
    }

    public static AbilityLevelMessage decode(FriendlyByteBuf buffer) {
        return new AbilityLevelMessage(buffer.m_130277_(), buffer.readBoolean());
    }

    public static void handle(AbilityLevelMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            if (message.isUpgrade) {
                AbilityLevelMessage.upgradeAbility(message, sender);
            } else {
                AbilityLevelMessage.downgradeAbility(message, sender);
            }
        });
        context.setPacketHandled(true);
    }

    private static void upgradeAbility(AbilityLevelMessage message, ServerPlayer player) {
        ServerLevel level = player.m_183503_();
        AbilityGroup<?, ?> abilityGroup = ModConfigs.ABILITIES.getAbilityGroupByName(message.abilityName);
        PlayerVaultStatsData statsData = PlayerVaultStatsData.get(level);
        PlayerAbilitiesData abilitiesData = PlayerAbilitiesData.get(level);
        AbilityTree abilityTree = abilitiesData.getAbilities((Player)player);
        AbilityNode<?, ?> abilityNode = abilityTree.getNodeByName(message.abilityName);
        PlayerVaultStats stats = statsData.getVaultStats((Player)player);
        if (stats.getVaultLevel() < ((AbstractAbilityConfig)abilityNode.getAbilityConfig()).getLevelRequirement()) {
            return;
        }
        if (abilityNode.getLevel() >= abilityGroup.getMaxLevel()) {
            return;
        }
        int requiredSkillPts = abilityGroup.levelUpCost(abilityNode.getSpecialization(), abilityNode.getLevel() + 1);
        if (stats.getUnspentSkillPoints() >= requiredSkillPts) {
            abilitiesData.upgradeAbility(player, abilityNode);
            statsData.spendSkillPoints(player, requiredSkillPts);
        }
    }

    private static void downgradeAbility(AbilityLevelMessage message, ServerPlayer player) {
        boolean isSpecialization;
        ServerLevel level = player.m_183503_();
        AbilityGroup<?, ?> abilityGroup = ModConfigs.ABILITIES.getAbilityGroupByName(message.abilityName);
        PlayerVaultStatsData statsData = PlayerVaultStatsData.get(level);
        PlayerAbilitiesData abilitiesData = PlayerAbilitiesData.get(level);
        AbilityTree abilityTree = abilitiesData.getAbilities((Player)player);
        AbilityNode<?, ?> abilityNode = abilityTree.getNodeByName(message.abilityName);
        Object ability = abilityNode.getAbility();
        PlayerVaultStats stats = statsData.getVaultStats((Player)player);
        if (ability == null || abilityNode.getAbilityConfig() == null || !abilityNode.isLearned()) {
            return;
        }
        boolean bl = isSpecialization = !((AbstractAbility)ability).getAbilityGroupName().equals(message.abilityName);
        if (isSpecialization) {
            return;
        }
        int requiredRegretPoints = ((AbstractAbilityConfig)abilityNode.getAbilityConfig()).getRegretCost();
        if (abilityNode.getLevel() == 1) {
            List<AbilityGroup<?, ?>> dependentNodes = ModConfigs.SKILL_GATES.getGates().getAbilitiesDependingOn(abilityGroup.getParentName());
            for (AbilityGroup<?, ?> dependent : dependentNodes) {
                if (!abilityTree.getNodeOf(dependent).isLearned()) continue;
                return;
            }
        }
        if (stats.getUnspentRegretPoints() >= requiredRegretPoints) {
            abilitiesData.downgradeAbility(player, abilityNode);
            statsData.spendSkillPoints(player, -((AbstractAbilityConfig)abilityNode.getAbilityConfig()).getLearningCost());
            statsData.spendRegretPoints(player, requiredRegretPoints);
        }
    }
}

