/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.ClientAbilityData;
import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.AbilityTree;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class AbilityKnownOnesMessage {
    private final List<AbilityNode<?, ?>> learnedAbilities;

    public AbilityKnownOnesMessage(AbilityTree abilityTree) {
        this(abilityTree.getLearnedNodes());
    }

    private AbilityKnownOnesMessage(List<AbilityNode<?, ?>> learnedAbilities) {
        this.learnedAbilities = learnedAbilities;
    }

    public List<AbilityNode<?, ?>> getLearnedAbilities() {
        return this.learnedAbilities;
    }

    public static void encode(AbilityKnownOnesMessage message, FriendlyByteBuf buffer) {
        CompoundTag nbt = new CompoundTag();
        ListTag abilities = new ListTag();
        message.learnedAbilities.stream().map(AbilityNode::serializeNBT).forEach(arg_0 -> abilities.add(arg_0));
        nbt.m_128365_("LearnedAbilities", (Tag)abilities);
        buffer.m_130079_(nbt);
    }

    public static AbilityKnownOnesMessage decode(FriendlyByteBuf buffer) {
        ArrayList abilities = new ArrayList();
        CompoundTag nbt = buffer.m_130260_();
        ListTag learnedAbilities = nbt.m_128437_("LearnedAbilities", 10);
        for (int i = 0; i < learnedAbilities.size(); ++i) {
            abilities.add(AbilityNode.fromNBT(learnedAbilities.m_128728_(i)));
        }
        return new AbilityKnownOnesMessage(abilities);
    }

    public static void handle(AbilityKnownOnesMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientAbilityData.updateAbilities(message));
        context.setPacketHandled(true);
    }
}

