/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.entity.entity.SpiritEntity;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.calc.BlockChanceHelper;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class MixinPlayerEntity
extends LivingEntity
implements BlockChanceHelper.PlayerBlockAnimationAccess {
    private static EntityDataAccessor<Boolean> PLAYER_BLOCKING;
    private int shieldActiveTimeout = 0;

    @Shadow
    public abstract void m_6667_(DamageSource var1);

    protected MixinPlayerEntity(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    protected void addVisualBlockIndicatorEntry(CallbackInfo ci) {
        if (PLAYER_BLOCKING == null) {
            PLAYER_BLOCKING = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        }
        this.m_20088_().m_135372_(PLAYER_BLOCKING, (Object)false);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    protected void shieldTick(CallbackInfo ci) {
        if (this.m_183503_().m_5776_()) {
            return;
        }
        if (this.shieldActiveTimeout > 0) {
            --this.shieldActiveTimeout;
        }
        if (this.shieldActiveTimeout <= 0) {
            this.m_20088_().m_135381_(PLAYER_BLOCKING, (Object)false);
        }
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;getSweepingDamageRatio(Lnet/minecraft/world/entity/LivingEntity;)F"))
    private float getSweepingEdgeRatio(LivingEntity entity) {
        Player thisPlayer = (Player)this;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)thisPlayer);
        float chance = snapshot.getAttributeValue(ModGearAttributes.SWEEPING_HIT_CHANCE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        if (this.f_19796_.nextFloat() >= chance) {
            return EnchantmentHelper.m_44821_((LivingEntity)thisPlayer);
        }
        int level = 1;
        return 1.0f - 1.0f / (float)(level + 1);
    }

    @Override
    public void setForceBlocking() {
        this.shieldActiveTimeout = 20;
        this.m_20088_().m_135381_(PLAYER_BLOCKING, (Object)true);
    }

    @Override
    public boolean isForceBlocking() {
        return (Boolean)this.m_20088_().m_135370_(PLAYER_BLOCKING);
    }

    public boolean canBeRiddenInWater(Entity rider) {
        if (rider instanceof SpiritEntity) {
            return true;
        }
        return super.canBeRiddenInWater(rider);
    }
}

