/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.init.ModDynamicModels;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModelBakery.class})
public class MixinModelBakery {
    @Final
    @Shadow
    protected ResourceManager f_119243_;

    @Inject(method={"loadBlockModel"}, at={@At(value="HEAD")}, cancellable=true)
    public void loadBlockModel(ResourceLocation resourceLocation, CallbackInfoReturnable<BlockModel> cir) {
        if (resourceLocation.m_135815_().startsWith("item/")) {
            ResourceLocation itemModelLocation = DynamicModel.removePrefixFromId("item/", resourceLocation);
            ModDynamicModels.REGISTRIES.getModelByResourceLocation(itemModelLocation).ifPresent(dynamicModel -> {
                BlockModel itemModel = this.loadItemModel(resourceLocation, (DynamicModel<?>)dynamicModel);
                itemModel.f_111416_ = resourceLocation.toString();
                cir.setReturnValue((Object)itemModel);
            });
        }
    }

    private BlockModel loadItemModel(ResourceLocation resourceLocation, DynamicModel<?> dynamicModel) {
        ResourceManager resourceManager = this.f_119243_;
        if (ModDynamicModels.jsonModelExists(resourceManager, resourceLocation)) {
            try {
                ResourceLocation modelPath = new ResourceLocation(resourceLocation.m_135827_(), "models/" + resourceLocation.m_135815_() + ".json");
                Resource resource = resourceManager.m_142591_(modelPath);
                InputStreamReader reader = new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8);
                return BlockModel.m_111461_((Reader)reader);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Map<String, ResourceLocation> textures = dynamicModel.resolveTextures(resourceManager, resourceLocation);
        return dynamicModel.generateItemModel(textures);
    }
}

