/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.util.calc.ResistanceHelper;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity {
    private float prevSize = -1.0f;

    public MixinLivingEntity(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    @Shadow
    public abstract EntityDimensions m_6972_(Pose var1);

    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    @Shadow
    @Nullable
    public abstract MobEffectInstance m_21124_(MobEffect var1);

    @Shadow
    @Nullable
    public abstract AttributeInstance m_21051_(Attribute var1);

    @Shadow
    public abstract ItemStack m_21120_(InteractionHand var1);

    @Redirect(method={"createLivingAttributes"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier;builder()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"))
    private static AttributeSupplier.Builder registerAttributes() {
        return AttributeSupplier.m_22244_().m_22266_(Attributes.f_22276_).m_22266_(Attributes.f_22278_).m_22266_(Attributes.f_22279_).m_22266_(Attributes.f_22284_).m_22266_(Attributes.f_22285_).m_22266_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22266_((Attribute)ForgeMod.NAMETAG_DISTANCE.get()).m_22266_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22266_(ModAttributes.CRIT_CHANCE).m_22266_(ModAttributes.CRIT_MULTIPLIER).m_22266_(ModAttributes.TP_CHANCE).m_22266_(ModAttributes.TP_INDIRECT_CHANCE).m_22266_(ModAttributes.TP_RANGE).m_22266_(ModAttributes.POTION_RESISTANCE).m_22266_(ModAttributes.SIZE_SCALE).m_22266_(ModAttributes.BREAK_ARMOR_CHANCE).m_22266_(ModAttributes.MANA_MAX).m_22266_(ModAttributes.MANA_REGEN);
    }

    @Inject(method={"getDamageAfterMagicAbsorb"}, at={@At(value="RETURN")}, cancellable=true)
    public void applyResistance(DamageSource pSource, float pDamage, CallbackInfoReturnable<Float> cir) {
        float resistance;
        LivingEntity entity = (LivingEntity)this;
        if (AttributeSnapshotHelper.canHaveSnapshot(entity) && (double)(resistance = ResistanceHelper.getResistance(entity)) > 1.0E-4) {
            float damage = ((Float)cir.getReturnValue()).floatValue();
            cir.setReturnValue((Object)Float.valueOf(Math.max(damage - damage * resistance, 0.0f)));
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void tick(CallbackInfo ci) {
        AttributeInstance scale = this.m_21051_(ModAttributes.SIZE_SCALE);
        if (scale == null) {
            return;
        }
        if ((double)this.prevSize != scale.m_22135_()) {
            this.prevSize = (float)scale.m_22135_();
            this.f_19815_ = this.m_6972_(Pose.STANDING).m_20388_(this.prevSize);
            this.m_6210_();
        }
    }

    @Inject(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void addPotionEffect(MobEffectInstance effect, CallbackInfoReturnable<Boolean> ci) {
        AttributeInstance attribute = this.m_21051_(ModAttributes.POTION_RESISTANCE);
        if (attribute == null) {
            return;
        }
        if (this.f_19796_.nextDouble() >= attribute.m_22135_()) {
            return;
        }
        ci.setReturnValue((Object)false);
    }

    @Redirect(method={"collectEquipmentChanges"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getAttributeModifiers(Lnet/minecraft/world/entity/EquipmentSlot;)Lcom/google/common/collect/Multimap;"))
    private Multimap<Attribute, AttributeModifier> preventVanillaAttributes(ItemStack stack, EquipmentSlot slot) {
        LivingEntity entity = (LivingEntity)this;
        if (stack.m_41720_() instanceof VaultGearItem && entity instanceof Player) {
            Player player = (Player)entity;
            int playerLevel = SidedHelper.getVaultLevel(player);
            if (VaultGearData.read(stack).getItemLevel() > playerLevel) {
                return HashMultimap.create();
            }
        }
        return stack.m_41638_(slot);
    }
}

