/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.config.DurabilityConfig;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.IConditionalDamageable;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class}, priority=1001)
public abstract class MixinItemStack {
    @Shadow
    public abstract int m_41776_();

    @Shadow
    public abstract ItemStack m_41777_();

    @Shadow
    public abstract Item m_41720_();

    @Shadow
    public abstract boolean m_41763_();

    @Shadow
    public abstract int m_41773_();

    @Shadow
    public abstract void m_41721_(int var1);

    @Overwrite
    public boolean m_41629_(int damage, Random rand, @Nullable ServerPlayer damager) {
        if (!this.m_41763_()) {
            return false;
        }
        if (damage > 0) {
            IConditionalDamageable cd;
            Item item = this.m_41720_();
            if (item instanceof IConditionalDamageable && (cd = (IConditionalDamageable)item).isImmuneToDamage((ItemStack)this, (Player)damager)) {
                return false;
            }
            int unbreaking = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)((ItemStack)this));
            int durabilityNegation = 0;
            boolean isArmor = ((ItemStack)this).m_41720_() instanceof ArmorItem;
            DurabilityConfig cfg = ModConfigs.DURBILITY;
            float chance = isArmor ? cfg.getArmorDurabilityIgnoreChance(unbreaking) : cfg.getDurabilityIgnoreChance(unbreaking);
            for (int k = 0; unbreaking > 0 && k < damage; ++k) {
                if (!(rand.nextFloat() < chance)) continue;
                ++durabilityNegation;
            }
            int wearReduction = 0;
            if (damager != null) {
                AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)damager);
                float wearReductionChance = snapshot.getAttributeValue(ModGearAttributes.DURABILITY_WEAR_REDUCTION, VaultGearAttributeTypeMerger.floatSum()).floatValue();
                for (int k = 0; k < damage; ++k) {
                    if (!(rand.nextFloat() < wearReductionChance)) continue;
                    ++wearReduction;
                }
            }
            damage -= durabilityNegation;
            if ((damage -= wearReduction) <= 0) {
                return false;
            }
        }
        if (damager != null && damage != 0) {
            CriteriaTriggers.f_10586_.m_43669_(damager, (ItemStack)this, this.m_41773_() + damage);
        }
        int absDamage = this.m_41773_() + damage;
        this.m_41721_(absDamage);
        return absDamage >= this.m_41776_();
    }

    @Inject(method={"getDisplayName"}, at={@At(value="RETURN")}, cancellable=true)
    public void useGearRarity(CallbackInfoReturnable<Component> ci) {
        if (!(this.m_41720_() instanceof VaultGearItem)) {
            return;
        }
        ItemStack itemStack = this.m_41777_();
        VaultGearData data = VaultGearData.read(itemStack);
        VaultGearState state = data.getState();
        if (state == VaultGearState.UNIDENTIFIED) {
            return;
        }
        MutableComponent returnValue = (MutableComponent)ci.getReturnValue();
        Style style = returnValue.m_7383_().m_131148_(data.getRarity().getColor());
        ci.setReturnValue((Object)returnValue.m_6270_(style));
    }

    @Redirect(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isDamaged()Z"))
    public boolean alwaysShowDamageTooltip(ItemStack stack) {
        VaultGearData data;
        if (stack.m_41720_() instanceof VaultGearItem && (data = VaultGearData.read(stack)).getState() == VaultGearState.IDENTIFIED) {
            return true;
        }
        return stack.m_41768_();
    }
}

