/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.mixin;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.paxel.PaxelItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.class})
public class BlockMixin {
    @Inject(method={"getDrops"}, cancellable=true, at={@At(value="RETURN")})
    public void onItemRightClick(BlockState pState, LootContext.Builder pBuilder, CallbackInfoReturnable<List<ItemStack>> cir) {
        ItemStack stack = (ItemStack)pBuilder.m_78982_(LootContextParams.f_81463_);
        if (stack != null && stack.m_41720_() instanceof PaxelItem) {
            List<PaxelItem.Perk> perks = PaxelItem.getPerks(stack);
            if (perks.contains((Object)PaxelItem.Perk.PULVERISING)) {
                Optional<ItemStack> opt = ModConfigs.PAXEL_CONFIGS.getPulverizedState(pState, pBuilder.m_78962_().f_46441_);
                opt.ifPresent(itemStack -> cir.setReturnValue(List.of(itemStack)));
            }
            if (perks.contains((Object)PaxelItem.Perk.SMELTING)) {
                List list = (List)cir.getReturnValue();
                ArrayList<ItemStack> newList = new ArrayList<ItemStack>();
                for (ItemStack l : list) {
                    ItemStack itemstack;
                    Optional optional = pBuilder.m_78962_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{l}), (Level)pBuilder.m_78962_());
                    if (optional.isPresent() && !(itemstack = ((SmeltingRecipe)optional.get()).m_8043_()).m_41619_()) {
                        ItemStack smelted = itemstack.m_41777_();
                        smelted.m_41764_(l.m_41613_() * itemstack.m_41613_());
                        newList.add(smelted);
                        continue;
                    }
                    newList.add(l);
                }
                cir.setReturnValue(newList);
            }
        }
    }
}

