/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.paxel;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import iskallia.vault.config.PaxelConfigs;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.event.InputEvents;
import iskallia.vault.gear.tooltip.VaultGearDataTooltip;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.IConditionalDamageable;
import iskallia.vault.item.paxel.PaxelItemTier;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PaxelItem
extends DiggerItem
implements IConditionalDamageable {
    private static final UUID PAXEL_REACH_ID = UUID.randomUUID();

    public PaxelItem(ResourceLocation id) {
        super(3.0f, -3.0f, (Tier)PaxelItemTier.INSTANCE, BlockTags.f_144282_, new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(1));
        this.setRegistryName(id);
    }

    @Override
    public boolean isImmuneToDamage(ItemStack stack, @Nullable Player player) {
        return player != null && PaxelItem.getPerks(stack).contains((Object)Perk.IMMORTAL) && !ServerVaults.isInVault((Entity)player);
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        List<Perk> perks = PaxelItem.getPerks(pStack);
        if (PaxelItem.isCorrectTool(pState, perks)) {
            boolean isQuick = perks.contains((Object)Perk.QUICK);
            return PaxelItem.getUsableStat(pStack, Stat.MINING_SPEED) * (isQuick ? 1.25f : 1.0f);
        }
        return 1.0f;
    }

    private static boolean isCorrectTool(BlockState pState, List<Perk> perks) {
        return pState.m_204336_(BlockTags.f_144282_) || pState.m_204336_(BlockTags.f_144280_) && perks.contains((Object)Perk.AXING) || pState.m_204336_(BlockTags.f_144283_) && perks.contains((Object)Perk.SHOVELING) || pState.m_204336_(BlockTags.f_144281_) && perks.contains((Object)Perk.FARMING);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return PaxelItem.isCorrectTool(state, PaxelItem.getPerks(stack)) && TierSortingRegistry.isCorrectTierForDrops((Tier)this.m_43314_(), (BlockState)state);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44962_) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        if (EnchantmentHelper.m_44831_((ItemStack)book).containsKey(Enchantments.f_44962_)) {
            return false;
        }
        return super.isBookEnchantable(stack, book);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (worldIn == null) {
            return;
        }
        int level = PaxelItem.getPaxelLevel(stack);
        tooltip.add((Component)new TextComponent("Level " + ChatFormatting.YELLOW + level));
        VaultGearDataTooltip.addRepairTooltip(tooltip, PaxelItem.getUsedRepairSlots(stack), PaxelItem.getMaxRepairSlots(stack));
        int sockets = PaxelItem.getSockets(stack);
        if (sockets != 0) {
            tooltip.add((Component)new TextComponent("Sockets: ").m_7220_(VaultGearDataTooltip.tooltipDots(sockets, ChatFormatting.GRAY)));
        }
        tooltip.add((Component)new TextComponent(" "));
        for (Stat s : Stat.values()) {
            float value = PaxelItem.getStatUpgrade(stack, s);
            if (value == 0.0f) continue;
            PaxelConfigs.Upgrade upgradeCfg = ModConfigs.PAXEL_CONFIGS.getUpgrade(s);
            String valueStr = upgradeCfg.formatValue(value);
            MutableComponent component = new TextComponent(s.getReadableName() + (value > 0.0f ? " +" : " ") + valueStr).m_130948_(Style.f_131099_.m_131148_(ModConfigs.PAXEL_CONFIGS.getStatColor(s)));
            if (InputEvents.isShiftDown()) {
                component.m_7220_((Component)new TextComponent(" " + ChatFormatting.DARK_GRAY + upgradeCfg.getAdvancedTooltip()));
            }
            tooltip.add((Component)component);
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public static int getPaxelLevel(ItemStack stack) {
        return (100 - PaxelItem.getSturdiness(stack)) / ModConfigs.MAGNET_CONFIG.getSturdinessDecrement();
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        int durability = this.getMaxDamage(stack);
        float miningSpeed = PaxelItem.getUsableStat(stack, Stat.MINING_SPEED);
        float reach = PaxelItem.getUsableStat(stack, Stat.REACH);
        float copiously = PaxelItem.getUsableStat(stack, Stat.COPIOUSLY);
        List<Perk> perks = PaxelItem.getPerks(stack);
        return Optional.of(new PaxelTooltip(durability, miningSpeed, reach, copiously, perks));
    }

    public static ChatFormatting getSturdinessColor(int sturdiness) {
        float cc = ModConfigs.MAGNET_CONFIG.getSturdinessCutoff();
        ChatFormatting cl = (float)sturdiness <= cc ? ChatFormatting.RED : ((float)sturdiness < cc + (100.0f - cc) / 2.0f ? ChatFormatting.YELLOW : ChatFormatting.GREEN);
        return cl;
    }

    public static int getMaxRepairSlots(ItemStack stack) {
        return ModConfigs.PAXEL_CONFIGS.getTierValues(stack).getBaseRepairSlots() + (PaxelItem.getPerks(stack).contains((Object)Perk.REINFORCED) ? 2 : 0);
    }

    public static int getUsedRepairSlots(ItemStack stack) {
        return stack.m_41784_().m_128451_("UsedRepairs");
    }

    public static void useRepairSlot(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        int current = tag.m_128451_("UsedRepairs");
        tag.m_128405_("UsedRepairs", current + 1);
    }

    public static int getSockets(ItemStack stack) {
        return stack.m_41784_().m_128451_("Sockets");
    }

    public static void setSockets(ItemStack stack, int sockets) {
        stack.m_41784_().m_128405_("Sockets", sockets);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return toRepair.m_41720_() instanceof PaxelItem && repair.m_41720_() == ModItems.REPAIR_CORE;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        int durability = Mth.m_14167_((float)(PaxelItem.getUsableStat(stack, Stat.DURABILITY) + PaxelItem.getReinforcedDurability(stack))) + ModConfigs.PAXEL_CONFIGS.getTierValues(stack).getAdditionalDurability();
        if (PaxelItem.getPerks(stack).contains((Object)Perk.STURDY)) {
            durability = (int)((float)durability * 1.5f);
        }
        return durability;
    }

    public static float getUsableStat(ItemStack stack, Stat stat) {
        return PaxelItem.getBaseStat(stat) + PaxelItem.getStatUpgrade(stack, stat);
    }

    public static float getBaseStat(Stat stat) {
        return ModConfigs.PAXEL_CONFIGS.getUpgrade(stat).getBaseValue();
    }

    public static float getStatUpgrade(ItemStack stack, Stat stat) {
        CompoundTag c = stack.m_41784_();
        return c.m_128457_(stat.name);
    }

    public static void increaseStatUpgrade(ItemStack stack, Stat stat, float increase) {
        CompoundTag c = stack.m_41784_();
        c.m_128350_(stat.name, c.m_128457_(stat.name) + increase);
    }

    public static void setLevel(ItemStack stack, int level) {
        stack.m_41784_().m_128405_("Level", level);
    }

    public static int getLevel(ItemStack stack) {
        return stack.m_41784_().m_128451_("Level");
    }

    public static int getSturdiness(ItemStack stack) {
        return 100 - PaxelItem.getLevel(stack) * ModConfigs.PAXEL_CONFIGS.getTierValues(stack).getSturdinessDecrement();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (ModConfigs.isInitialized() && slot == EquipmentSlot.MAINHAND) {
            return ImmutableMultimap.of((Object)((Attribute)ForgeMod.REACH_DISTANCE.get()), (Object)new AttributeModifier(PAXEL_REACH_ID, "PaxelReach", (double)PaxelItem.getUsableStat(stack, Stat.REACH), AttributeModifier.Operation.ADDITION));
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public static float getReinforcedDurability(ItemStack stack) {
        return stack.m_41784_().m_128457_("ReinforcedDurability");
    }

    public static void setReinforcedDurability(ItemStack stack, float durability) {
        stack.m_41784_().m_128350_("ReinforcedDurability", durability);
    }

    public static List<Perk> getPerks(ItemStack stack) {
        CompoundTag c = stack.m_41784_();
        return Arrays.stream(c.m_128465_("Perks")).mapToObj(i -> Perk.values()[i]).toList();
    }

    public static void addPerk(ItemStack stack, Perk perk) {
        CompoundTag tag = stack.m_41784_();
        ArrayList<Integer> perks = new ArrayList<Integer>();
        for (int i : tag.m_128465_("Perks")) {
            perks.add(i);
        }
        perks.add(perk.ordinal());
        tag.m_128408_("Perks", perks);
    }

    public static boolean canAddPerk(ItemStack stack, Perk perk) {
        List<Perk> perks = PaxelItem.getPerks(stack);
        if (perk.digRadius != 0 && perks.stream().anyMatch(p -> p.digRadius != 0)) {
            return false;
        }
        return !perks.contains((Object)perk);
    }

    public boolean m_41465_() {
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        int range;
        if (ActiveFlags.IS_AOE_MINING.isSet()) {
            return false;
        }
        List<Perk> perks = PaxelItem.getPerks(stack);
        if (perks.contains((Object)Perk.SHATTERING)) {
            range = Perk.SHATTERING.digRadius;
        } else if (perks.contains((Object)Perk.EXCAVATING)) {
            range = Perk.EXCAVATING.digRadius;
        } else if (perks.contains((Object)Perk.HAMMERING)) {
            range = Perk.HAMMERING.digRadius;
        } else {
            return false;
        }
        range = (range - 1) / 2;
        HitResult hitResult = player.m_19907_(player.getReachDistance(), 1.0f, false);
        if (!player.f_19853_.f_46443_ && hitResult.m_6662_() == HitResult.Type.BLOCK) {
            Direction face = ((BlockHitResult)hitResult).m_82434_();
            this.areaDig(range, player, stack, pos, pos, face);
        }
        return false;
    }

    private void areaDig(int range, Player player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        Direction ort1;
        Level level = player.f_19853_;
        if (!level.isAreaLoaded(pos, range)) {
            return;
        }
        Iterator it = BlockPos.m_121935_((BlockPos)pos, (int)range, (Direction)ort1, (Direction)(switch (side.m_122434_()) {
            default -> {
                ort1 = Direction.UP;
                yield Direction.SOUTH;
            }
            case Direction.Axis.Y -> {
                ort1 = Direction.SOUTH;
                yield Direction.EAST;
            }
            case Direction.Axis.Z -> {
                ort1 = Direction.EAST;
                yield Direction.UP;
            }
        })).iterator();
        while (it.hasNext() && !stack.m_41619_()) {
            this.destroyBlock((ServerLevel)level, (ServerPlayer)player, ((BlockPos.MutableBlockPos)it.next()).m_7949_());
        }
    }

    public void destroyBlock(ServerLevel level, ServerPlayer player, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_60795_() || !player.m_7500_() && blockState.m_60625_((Player)player, (BlockGetter)level, pos) == 0.0f) {
            return;
        }
        ActiveFlags.IS_AOE_MINING.runIfNotSet(() -> {
            if (player.f_8941_.m_9280_(pos)) {
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)blockState));
            }
        });
    }

    public static enum Perk implements StringRepresentable
    {
        QUICK("Quick"),
        IMMORTAL("Immortal"),
        STURDY("Sturdy"),
        HAMMERING("Hammering", 3),
        EXCAVATING("Excavating", 5),
        SHATTERING("Shattering", 7),
        SMELTING("Smelting"),
        PULVERISING("Pulverising"),
        REINFORCED("Reinforced"),
        AXING("Axing"),
        SHOVELING("Shoveling"),
        FARMING("Farming");

        private final int digRadius;
        private final String name;

        private Perk(String name, int digRadius) {
            this.name = name;
            this.digRadius = digRadius;
        }

        private Perk(String name) {
            this(name, 0);
        }

        public String m_7912_() {
            return this.name;
        }

        public int getDigRadius() {
            return this.digRadius;
        }
    }

    public static enum Stat implements StringRepresentable
    {
        DURABILITY("Durability", "Durability"),
        REACH("Reach", "Reach"),
        MINING_SPEED("MiningSpeed", "Mining Speed"),
        COPIOUSLY("Copiously", "Copiously");

        private final String name;
        private final String readableName;

        private Stat(String name, String readableName) {
            this.name = name;
            this.readableName = readableName;
        }

        public String m_7912_() {
            return this.name;
        }

        public String getReadableName() {
            return this.readableName;
        }
    }

    public static final class PaxelTooltip
    implements TooltipComponent {
        public final Stat[] stats = new Stat[]{Stat.DURABILITY, Stat.REACH, Stat.MINING_SPEED, Stat.COPIOUSLY};
        public final float[] statValues;
        public final TreeSet<Perk> perks;

        public PaxelTooltip(float durability, float miningSpeed, float reach, float copiously, List<Perk> perks) {
            this.statValues = new float[]{durability, reach, miningSpeed, copiously};
            this.perks = new TreeSet<Perk>(perks);
        }
    }
}

