/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.gear;

import iskallia.vault.config.TrinketConfig;
import iskallia.vault.gear.GearRollHelper;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.TrinketEffectRegistry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.BasicItem;
import iskallia.vault.item.gear.DataTransferItem;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.VHSmpUtil;
import iskallia.vault.world.data.DiscoveredTrinketsData;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class TrinketItem
extends BasicItem
implements ICurioItem,
DataTransferItem {
    public TrinketItem(ResourceLocation id) {
        super(id, new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(1));
    }

    public static ItemStack createRandomTrinket(TrinketEffect<?> trinket) {
        ItemStack stack = TrinketItem.createBaseTrinket(trinket);
        TrinketItem.setUses(stack, trinket.getTrinketConfig().getRandomUses());
        return stack;
    }

    public static ItemStack createBaseTrinket(TrinketEffect<?> trinket) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.TRINKET);
        Object data = AttributeGearData.read(stack);
        ((AttributeGearData)data).updateAttribute(ModGearAttributes.STATE, (VaultGearState)VaultGearState.IDENTIFIED);
        ((AttributeGearData)data).updateAttribute(ModGearAttributes.TRINKET_EFFECT, trinket);
        ((AttributeGearData)data).write(stack);
        return stack;
    }

    public static Optional<String> getSlotIdentifier(ItemStack stack) {
        return TrinketItem.getTrinket(stack).map(TrinketEffect::getConfig).filter(TrinketEffect.Config::hasCuriosSlot).map(TrinketEffect.Config::getCuriosSlot);
    }

    public static Optional<TrinketEffect<?>> getTrinket(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem)) {
            return Optional.empty();
        }
        TrinketEffect<?> data = AttributeGearData.read(stack);
        return ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.TRINKET_EFFECT);
    }

    public static int getUses(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem)) {
            return 0;
        }
        return stack.m_41784_().m_128451_("vaultUses");
    }

    public static void setUses(ItemStack stack, int uses) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem)) {
            return;
        }
        stack.m_41784_().m_128405_("vaultUses", uses);
    }

    public static boolean hasUsesLeft(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem)) {
            return false;
        }
        return TrinketItem.getUses(stack) > TrinketItem.getUsedVaults(stack).size();
    }

    public static List<UUID> getUsedVaults(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem)) {
            return Collections.emptyList();
        }
        ListTag list = stack.m_41784_().m_128437_("usedVaults", 10);
        ArrayList<UUID> ids = new ArrayList<UUID>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            ids.add(tag.m_128342_("id"));
        }
        return ids;
    }

    public static void addUsedVault(ItemStack stack, UUID vaultId) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem)) {
            return;
        }
        ListTag list = stack.m_41784_().m_128437_("usedVaults", 10);
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("id", vaultId);
        list.add((Object)tag);
        stack.m_41784_().m_128365_("usedVaults", (Tag)list);
    }

    public static boolean isUsableInVault(ItemStack stack, UUID vaultId) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem) || vaultId == null) {
            return false;
        }
        ListTag list = stack.m_41784_().m_128437_("usedVaults", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            if (!vaultId.equals(tag.m_128342_("id"))) continue;
            return true;
        }
        return false;
    }

    public static boolean isIdentified(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TrinketItem)) {
            return false;
        }
        VaultGearState data = AttributeGearData.read(stack);
        return ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.STATE).orElse(VaultGearState.UNIDENTIFIED) == VaultGearState.IDENTIFIED;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        super.m_6787_(tab, items);
        if (!ModConfigs.isInitialized()) {
            return;
        }
        if (this.m_41389_(tab)) {
            TrinketEffectRegistry.getOrderedEntries().stream().map(TrinketItem::createRandomTrinket).forEach(arg_0 -> items.add(arg_0));
        }
    }

    public Component m_7626_(ItemStack stack) {
        if (!TrinketItem.isIdentified(stack)) {
            return super.m_7626_(stack);
        }
        return TrinketItem.getTrinket(stack).map(effect -> {
            TrinketConfig.Trinket cfg = effect.getTrinketConfig();
            TextComponent cmp = new TextComponent(cfg.getName());
            cmp.m_130948_(Style.f_131099_.m_131148_(cfg.getComponentColor()));
            return cmp;
        }).orElseGet(() -> super.m_7626_(stack));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (!TrinketItem.isIdentified(stack)) {
            return;
        }
        int totalUses = TrinketItem.getUses(stack);
        int used = TrinketItem.getUsedVaults(stack).size();
        int remaining = Math.max(totalUses - used, 0);
        MutableComponent usesTxt = new TextComponent("Uses: ").m_7220_((Component)new TextComponent(String.valueOf(remaining)));
        tooltip.add((Component)usesTxt);
        String data = AttributeGearData.read(stack);
        ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.CRAFTED_BY).ifPresent(crafter -> tooltip.add((Component)new TextComponent("Crafted by: ").m_7220_((Component)new TextComponent(crafter).m_6270_(Style.f_131099_.m_178520_(16770048)))));
        TrinketItem.getTrinket(stack).ifPresent(effect -> {
            TrinketConfig.Trinket cfg = effect.getTrinketConfig();
            for (TextComponent cmp : MiscUtils.splitDescriptionText(cfg.getEffectText())) {
                tooltip.add((Component)cmp.m_130940_(ChatFormatting.GRAY));
            }
        });
        TrinketItem.getSlotIdentifier(stack).ifPresent(slotIdentifier -> {
            MutableComponent slotsTooltip = new TranslatableComponent("curios.slot").m_130946_(": ").m_130940_(ChatFormatting.GOLD);
            TranslatableComponent type = new TranslatableComponent("curios.identifier." + slotIdentifier);
            type = type.m_130940_(ChatFormatting.YELLOW);
            slotsTooltip.m_7220_((Component)type);
            tooltip.add(TextComponent.f_131282_);
            tooltip.add((Component)slotsTooltip);
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        VaultGearState data;
        ItemStack stack = player.m_21120_(hand);
        if (world.m_5776_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!ServerVaults.isVaultWorld(world) && !VHSmpUtil.isArenaWorld(world) && ((AttributeGearData)((Object)(data = AttributeGearData.read(stack)))).getFirstValue(ModGearAttributes.STATE).orElse(VaultGearState.UNIDENTIFIED) == VaultGearState.UNIDENTIFIED) {
            ((AttributeGearData)((Object)data)).updateAttribute(ModGearAttributes.STATE, (VaultGearState)VaultGearState.ROLLING);
            ((AttributeGearData)((Object)data)).write(stack);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)entity;
            if (world instanceof ServerLevel && stack.m_41613_() > 1) {
                while (stack.m_41613_() > 1) {
                    stack.m_41774_(1);
                    ItemStack etching = stack.m_41777_();
                    etching.m_41764_(1);
                    MiscUtils.giveItem(sPlayer, etching);
                }
            }
            if (((AttributeGearData)((Object)AttributeGearData.read(stack))).getFirstValue(ModGearAttributes.STATE).orElse(VaultGearState.UNIDENTIFIED) == VaultGearState.ROLLING) {
                GearRollHelper.tickToll(stack, sPlayer, rollStack -> {
                    TrinketEffect<?> data = AttributeGearData.read(stack);
                    TrinketEffect<?> randomTrinket = ModConfigs.TRINKET.getRandomTrinketSet();
                    if (randomTrinket != null) {
                        ((AttributeGearData)((Object)data)).updateAttribute(ModGearAttributes.TRINKET_EFFECT, randomTrinket);
                    }
                    ((AttributeGearData)((Object)data)).write((ItemStack)rollStack);
                }, finishStack -> {
                    Object data = AttributeGearData.read(stack);
                    TrinketEffect<?> randomTrinket = ModConfigs.TRINKET.getRandomTrinketSet();
                    if (randomTrinket != null) {
                        ((AttributeGearData)data).updateAttribute(ModGearAttributes.TRINKET_EFFECT, randomTrinket);
                        TrinketItem.setUses(stack, randomTrinket.getTrinketConfig().getRandomUses());
                        ((AttributeGearData)data).updateAttribute(ModGearAttributes.STATE, (VaultGearState)VaultGearState.IDENTIFIED);
                    } else {
                        ((AttributeGearData)data).updateAttribute(ModGearAttributes.STATE, (VaultGearState)VaultGearState.UNIDENTIFIED);
                    }
                    ((AttributeGearData)data).write((ItemStack)finishStack);
                    DiscoveredTrinketsData trinketData = DiscoveredTrinketsData.get(sPlayer.m_183503_().m_142572_());
                    trinketData.discoverTrinketAndBroadcast((ItemStack)finishStack, (Player)sPlayer);
                });
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (!TrinketItem.isIdentified(stack)) {
            return;
        }
        TrinketItem.getTrinket(stack).ifPresent(trinketEffect -> trinketEffect.onWornTick(slotContext.entity(), stack));
        super.curioTick(slotContext, stack);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if (!TrinketItem.isIdentified(stack)) {
            return;
        }
        TrinketItem.getTrinket(stack).ifPresent(trinketEffect -> trinketEffect.onEquip(slotContext.entity(), stack));
        super.onEquip(slotContext, prevStack, stack);
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        super.onEquipFromUse(slotContext, stack);
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && ServerVaults.isInVault((Entity)(player = (Player)livingEntity))) {
            return false;
        }
        if (!TrinketItem.isIdentified(stack)) {
            return false;
        }
        String slot = TrinketItem.getSlotIdentifier(stack).orElse(null);
        if (slot == null || !slot.equals(slotContext.identifier())) {
            return false;
        }
        if (CuriosApi.getSlotHelper() != null && !CuriosApi.getSlotHelper().getSlotType(slot).map(ISlotType::isVisible).orElse(false).booleanValue()) {
            return false;
        }
        return super.canEquip(slotContext, stack);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (!TrinketItem.isIdentified(stack)) {
            return;
        }
        TrinketItem.getTrinket(stack).ifPresent(trinketEffect -> trinketEffect.onUnEquip(slotContext.entity(), stack));
        super.onUnequip(slotContext, newStack, stack);
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && ServerVaults.isInVault((Entity)(player = (Player)livingEntity))) {
            return false;
        }
        return super.canUnequip(slotContext, stack);
    }
}

