/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.theme;

import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.core.data.key.ThemeKey;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.layout.ClassicVaultLayout;
import iskallia.vault.core.world.generator.layout.DIYVaultLayout;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.generator.theme.ClassicVaultTheme;
import iskallia.vault.core.world.generator.theme.DIYVaultTheme;
import iskallia.vault.core.world.generator.theme.Theme;
import iskallia.vault.item.crystal.theme.CrystalTheme;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;

public class ValueCrystalTheme
extends CrystalTheme {
    private ResourceLocation id;

    protected ValueCrystalTheme() {
    }

    public ValueCrystalTheme(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public void configure(Vault vault, RandomSource random) {
        ThemeKey key = VaultRegistry.THEME.getKey(this.id);
        if (key == null) {
            VaultMod.LOGGER.error("Theme with key [" + this.id + "] does not exist");
            return;
        }
        Theme theme = (Theme)key.get(vault.get(Vault.VERSION));
        if (theme == null || !vault.has(Vault.WORLD)) {
            return;
        }
        vault.get(Vault.WORLD).ifPresent(WorldManager.GENERATOR, generator -> {
            if (!(generator instanceof GridGenerator)) {
                return;
            }
            GridGenerator grid = (GridGenerator)generator;
            this.configureLayout(grid.get(GridGenerator.LAYOUT), theme);
        });
        vault.get(Vault.WORLD).ifPresent(WorldManager.RENDERER, renderer -> renderer.setTheme(theme));
    }

    private void configureLayout(GridLayout layout, Theme theme) {
        if (layout instanceof ClassicVaultLayout) {
            ClassicVaultLayout classic = (ClassicVaultLayout)layout;
            if (theme instanceof ClassicVaultTheme) {
                ClassicVaultTheme classicTheme = (ClassicVaultTheme)theme;
                ((GridLayout)((GridLayout)classic.set(ClassicVaultLayout.START_POOL, classicTheme.getStarts())).set(ClassicVaultLayout.ROOM_POOL, classicTheme.getRooms())).set(ClassicVaultLayout.TUNNEL_POOL, classicTheme.getTunnels());
            } else if (theme instanceof DIYVaultTheme) {
                DIYVaultTheme diyTheme = (DIYVaultTheme)theme;
                ((GridLayout)((GridLayout)classic.set(ClassicVaultLayout.START_POOL, diyTheme.getStarts())).set(ClassicVaultLayout.ROOM_POOL, diyTheme.getCommonRooms())).set(ClassicVaultLayout.TUNNEL_POOL, diyTheme.getTunnels());
            }
        } else if (layout instanceof DIYVaultLayout) {
            DIYVaultLayout diy = (DIYVaultLayout)layout;
            if (theme instanceof ClassicVaultTheme) {
                ClassicVaultTheme classicTheme = (ClassicVaultTheme)theme;
                ((GridLayout)((GridLayout)((GridLayout)((GridLayout)diy.set(DIYVaultLayout.START_POOL, classicTheme.getStarts())).set(DIYVaultLayout.COMMON_ROOM_POOL, classicTheme.getRooms())).set(DIYVaultLayout.CHALLENGE_ROOM_POOL, classicTheme.getRooms())).set(DIYVaultLayout.OMEGA_ROOM_POOL, classicTheme.getRooms())).set(DIYVaultLayout.TUNNEL_POOL, classicTheme.getTunnels());
            } else if (theme instanceof DIYVaultTheme) {
                DIYVaultTheme diyTheme = (DIYVaultTheme)theme;
                ((GridLayout)((GridLayout)((GridLayout)((GridLayout)diy.set(DIYVaultLayout.START_POOL, diyTheme.getStarts())).set(DIYVaultLayout.COMMON_ROOM_POOL, diyTheme.getCommonRooms())).set(DIYVaultLayout.CHALLENGE_ROOM_POOL, diyTheme.getChallengeRooms())).set(DIYVaultLayout.OMEGA_ROOM_POOL, diyTheme.getOmegaRooms())).set(DIYVaultLayout.TUNNEL_POOL, diyTheme.getTunnels());
            }
        }
    }

    @Override
    public void addText(List<Component> tooltip, TooltipFlag flag) {
        ThemeKey theme = VaultRegistry.THEME.getKey(this.id);
        if (theme == null) {
            return;
        }
        tooltip.add((Component)new TextComponent("Theme: ").m_7220_((Component)new TextComponent(theme.getName()).m_130940_(ChatFormatting.GOLD)));
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("type", "value");
        nbt.m_128359_("id", this.id.toString());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.id = new ResourceLocation(nbt.m_128461_("id"));
    }

    @Override
    public JsonObject serializeJson() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "value");
        object.addProperty("id", this.id.toString());
        return object;
    }

    @Override
    public void deserializeJson(JsonObject json) {
        this.id = new ResourceLocation(json.get("id").getAsString());
    }
}

