/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.objective;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.item.crystal.objective.BossCrystalObjective;
import iskallia.vault.item.crystal.objective.CakeCrystalObjective;
import iskallia.vault.item.crystal.objective.MonolithCrystalObjective;
import iskallia.vault.item.crystal.objective.ScavengerCrystalObjective;
import iskallia.vault.item.crystal.objective.SpeedrunCrystalObjective;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class CrystalObjective
implements INBTSerializable<CompoundTag> {
    public abstract void configure(Vault var1, RandomSource var2);

    public abstract Component getName();

    public abstract JsonObject serializeJson();

    public abstract void deserializeJson(JsonObject var1);

    public void addText(List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TextComponent("Objective: ").m_7220_(this.getName()));
    }

    public static CrystalObjective fromNBT(CompoundTag nbt) {
        CrystalObjective objective = switch (nbt.m_128461_("type")) {
            case "boss" -> new BossCrystalObjective();
            case "cake" -> new CakeCrystalObjective();
            case "scavenger" -> new ScavengerCrystalObjective();
            case "speedrun" -> new SpeedrunCrystalObjective();
            case "monolith" -> new MonolithCrystalObjective();
            default -> null;
        };
        objective.deserializeNBT((Tag)nbt);
        return objective;
    }

    public static String getId(CrystalObjective objective) {
        if (objective instanceof BossCrystalObjective) {
            return "boss";
        }
        if (objective instanceof CakeCrystalObjective) {
            return "cake";
        }
        if (objective instanceof ScavengerCrystalObjective) {
            return "scavenger";
        }
        if (objective instanceof SpeedrunCrystalObjective) {
            return "speedrun";
        }
        if (objective instanceof MonolithCrystalObjective) {
            return "monolith";
        }
        return "";
    }

    public static class Adapter
    implements JsonSerializer<CrystalObjective>,
    JsonDeserializer<CrystalObjective> {
        public static final Adapter INSTANCE = new Adapter();

        public CrystalObjective deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            CrystalObjective layout = switch (object.get("type").getAsString()) {
                case "boss" -> new BossCrystalObjective();
                case "cake" -> new CakeCrystalObjective();
                case "scavenger" -> new ScavengerCrystalObjective();
                case "speedrun" -> new SpeedrunCrystalObjective();
                case "monolith" -> new MonolithCrystalObjective();
                default -> null;
            };
            layout.deserializeJson(object);
            return layout;
        }

        public JsonElement serialize(CrystalObjective value, Type typeOfSrc, JsonSerializationContext context) {
            return value.serializeJson();
        }
    }
}

