/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.layout;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.layout.DIYRoomEntry;
import iskallia.vault.core.world.generator.layout.DIYVaultLayout;
import iskallia.vault.item.crystal.layout.CrystalLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.TooltipFlag;

public class DIYCrystalLayout
extends CrystalLayout {
    private int tunnelSpan;
    private List<DIYRoomEntry> entries = new ArrayList<DIYRoomEntry>();

    protected DIYCrystalLayout() {
    }

    public DIYCrystalLayout(int tunnelSpan, Collection<DIYRoomEntry> entries) {
        this.tunnelSpan = tunnelSpan;
        this.entries.addAll(entries);
    }

    public DIYCrystalLayout add(DIYRoomEntry entry) {
        for (DIYRoomEntry e : this.entries) {
            e.mergeWith(entry);
        }
        if (entry.get(DIYRoomEntry.COUNT) > 0) {
            this.entries.add(entry);
        }
        return this;
    }

    @Override
    public void configure(Vault vault) {
        if (!vault.has(Vault.WORLD)) {
            return;
        }
        vault.get(Vault.WORLD).ifPresent(WorldManager.GENERATOR, generator -> {
            if (!(generator instanceof GridGenerator)) {
                return;
            }
            GridGenerator grid = (GridGenerator)generator;
            grid.set(GridGenerator.LAYOUT, new DIYVaultLayout(this.tunnelSpan, this.entries));
        });
    }

    @Override
    public Component getName() {
        return new TextComponent("DIY").m_130940_(ChatFormatting.DARK_PURPLE);
    }

    @Override
    public void addText(List<Component> tooltip, TooltipFlag flag) {
        super.addText(tooltip, flag);
        for (DIYRoomEntry entry : this.entries) {
            int count = entry.get(DIYRoomEntry.COUNT);
            String roomStr = count > 1 ? "Rooms" : "Room";
            MutableComponent txt = new TextComponent("- Has ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.valueOf(count)).m_130940_(ChatFormatting.GOLD)).m_130946_(" ").m_7220_(entry.getName()).m_7220_((Component)new TextComponent(" " + roomStr).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)txt);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("type", "diy");
        nbt.m_128405_("tunnel_span", this.tunnelSpan);
        ListTag list = new ListTag();
        for (DIYRoomEntry entry : this.entries) {
            list.add((Object)entry.serializeNBT());
        }
        nbt.m_128365_("entries", (Tag)list);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.tunnelSpan = nbt.m_128451_("tunnel_span");
        this.entries.clear();
        ListTag list = nbt.m_128437_("entries", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.entries.add(DIYRoomEntry.fromNBT(list.m_128728_(i)));
        }
    }

    @Override
    public JsonObject serializeJson() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "diy");
        object.addProperty("tunnel_span", (Number)this.tunnelSpan);
        JsonArray list = new JsonArray();
        for (DIYRoomEntry entry : this.entries) {
            list.add((JsonElement)entry.serializeJson());
        }
        object.add("entries", (JsonElement)list);
        return object;
    }

    @Override
    public void deserializeJson(JsonObject json) {
        this.tunnelSpan = json.get("tunnel_span").getAsInt();
        this.entries.clear();
        JsonArray list = json.getAsJsonArray("entries");
        for (JsonElement element : list) {
            this.entries.add(DIYRoomEntry.fromJson(element.getAsJsonObject()));
        }
    }
}

