/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal.layout;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.item.crystal.layout.ClassicCircleCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicInfiniteCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicPolygonCrystalLayout;
import iskallia.vault.item.crystal.layout.ClassicSpiralCrystalLayout;
import iskallia.vault.item.crystal.layout.DIYCrystalLayout;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class CrystalLayout
implements INBTSerializable<CompoundTag> {
    public abstract void configure(Vault var1);

    public abstract Component getName();

    public abstract JsonObject serializeJson();

    public abstract void deserializeJson(JsonObject var1);

    public void addText(List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TextComponent("Layout: ").m_7220_(this.getName()));
    }

    public static CrystalLayout fromNBT(CompoundTag nbt) {
        CrystalLayout layout = switch (nbt.m_128461_("type")) {
            case "infinite" -> new ClassicInfiniteCrystalLayout();
            case "circle" -> new ClassicCircleCrystalLayout();
            case "polygon" -> new ClassicPolygonCrystalLayout();
            case "spiral" -> new ClassicSpiralCrystalLayout();
            case "diy" -> new DIYCrystalLayout();
            default -> null;
        };
        layout.deserializeNBT((Tag)nbt);
        return layout;
    }

    public static class Adapter
    implements JsonSerializer<CrystalLayout>,
    JsonDeserializer<CrystalLayout> {
        public static final Adapter INSTANCE = new Adapter();

        public CrystalLayout deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            CrystalLayout layout = switch (object.get("type").getAsString()) {
                case "infinite" -> new ClassicInfiniteCrystalLayout();
                case "circle" -> new ClassicCircleCrystalLayout();
                case "polygon" -> new ClassicPolygonCrystalLayout();
                case "spiral" -> new ClassicSpiralCrystalLayout();
                case "diy" -> new DIYCrystalLayout();
                default -> null;
            };
            layout.deserializeJson(object);
            return layout;
        }

        public JsonElement serialize(CrystalLayout value, Type typeOfSrc, JsonSerializationContext context) {
            return value.serializeJson();
        }
    }
}

