/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal;

import iskallia.vault.VaultMod;
import iskallia.vault.block.VaultPortalBlock;
import iskallia.vault.block.VaultPortalSize;
import iskallia.vault.block.entity.VaultPortalTileEntity;
import iskallia.vault.config.VaultCrystalCatalystConfig;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.FrameData;
import iskallia.vault.item.crystal.layout.ClassicInfiniteCrystalLayout;
import iskallia.vault.item.crystal.theme.PoolCrystalTheme;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.world.vault.modifier.VaultModifierStack;
import iskallia.vault.world.vault.modifier.registry.VaultModifierRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VaultCrystalItem
extends Item {
    private static final Random RANDOM = new Random();
    public static final String KEY_SCHEDULED_TASKS = "scheduledTasks";
    public static final String CLONED = "Cloned";
    private static final Map<String, IScheduledTaskDeserializer> SCHEDULED_TASK_DESERIALIZER_MAP = new HashMap<String, IScheduledTaskDeserializer>(){
        {
            this.put("exhaust", ExhaustTask::deserializeNBT);
            this.put("addRandomCurse", AddRandomCurseTask::deserializeNBT);
            this.put("addRandomCurses", AddRandomCursesTask::deserializeNBT);
            this.put("removeRandomCurse", RemoveRandomCurseTask::deserializeNBT);
            this.put("addClarity", AddClarityTask::deserializeNBT);
            this.put("echo", EchoTask::deserializeNBT);
            this.put("clone", CloneTask::deserializeNBT);
        }
    };

    public VaultCrystalItem(CreativeModeTab group, ResourceLocation id) {
        super(new Item.Properties().m_41491_(group).m_41487_(1));
        this.setRegistryName(id);
    }

    public static CrystalData getData(ItemStack stack) {
        return new CrystalData(stack);
    }

    public static ItemStack getCrystalWithBoss(String playerBossName) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        CrystalData data = new CrystalData(stack);
        data.setType(CrystalData.Type.RAFFLE);
        return stack;
    }

    public static ItemStack getCrystalWithObjective(ResourceLocation objectiveKey) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        CrystalData data = new CrystalData(stack);
        if (RANDOM.nextBoolean()) {
            data.setType(CrystalData.Type.COOP);
        }
        return stack;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            this.addEmptyCrystal(items);
            this.addDebugCrystal(items);
        }
    }

    private void addEmptyCrystal(NonNullList<ItemStack> items) {
        ItemStack stack = new ItemStack((ItemLike)this);
        CrystalData crystal = new CrystalData(stack);
        crystal.setTheme(new PoolCrystalTheme(VaultMod.id("default")));
        items.add((Object)stack);
    }

    private void addDebugCrystal(NonNullList<ItemStack> items) {
        ItemStack stack = new ItemStack((ItemLike)this);
        CrystalData crystal = new CrystalData(stack);
        crystal.setTheme(new PoolCrystalTheme(VaultMod.id("default")));
        crystal.setLayout(new ClassicInfiniteCrystalLayout(1));
        items.add((Object)stack);
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        CrystalData data = VaultCrystalItem.getData(stack);
        if (data.getEchoData().getEchoCount() > 0) {
            return new TextComponent("Echoed Vault Crystal").m_130940_(ChatFormatting.DARK_PURPLE);
        }
        return super.m_7626_(stack);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_ || context.m_43723_() == null) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = context.m_43723_().m_21120_(context.m_43724_());
        CrystalData data = new CrystalData(stack);
        if (data.getEchoData().getEchoCount() > 0) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        if (this.tryCreatePortal(context.m_43725_(), pos, context.m_43719_(), data)) {
            context.m_43725_().m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ModSounds.VAULT_PORTAL_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            MutableComponent playerName = context.m_43723_().m_5446_().m_6881_();
            playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
            String suffix = data.getType() == CrystalData.Type.FINAL_LOBBY ? " opened the Final Vault!" : " opened a Vault!";
            TextComponent suffixComponent = new TextComponent(suffix);
            context.m_43725_().m_142572_().m_6846_().m_11264_((Component)new TextComponent("").m_7220_((Component)playerName).m_7220_((Component)suffixComponent), ChatType.CHAT, context.m_43723_().m_142081_());
            context.m_43722_().m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    private boolean tryCreatePortal(Level world, BlockPos pos, Direction facing, CrystalData data) {
        Optional<VaultPortalSize> optional = VaultPortalSize.getPortalSize((LevelAccessor)world, pos.m_142300_(facing), Direction.Axis.X, VaultPortalBlock.FRAME);
        if (optional.isPresent()) {
            VaultPortalSize portal = optional.get();
            BlockState state = (BlockState)ModBlocks.VAULT_PORTAL.m_49966_().m_61124_((Property)VaultPortalBlock.f_54904_, (Comparable)portal.getAxis());
            data.frameData = new FrameData();
            for (int i = -1; i <= portal.getWidth(); ++i) {
                for (int j = -1; j <= portal.getHeight(); ++j) {
                    if (i != -1 && j != -1 && i != portal.getWidth() && j != portal.getHeight()) continue;
                    BlockPos p = portal.getBottomLeft().m_5484_(portal.getRightDir(), i).m_6630_(j);
                    BlockEntity te = world.m_7702_(p);
                    data.frameData.tiles.add(new FrameData.Tile(world.m_8055_(p).m_60734_(), te == null ? new CompoundTag() : te.serializeNBT(), p));
                }
            }
            data.updateDelegate();
            portal.placePortalBlocks(blockPos -> {
                world.m_7731_(blockPos, state, 3);
                BlockEntity te = world.m_7702_(blockPos);
                if (!(te instanceof VaultPortalTileEntity)) {
                    return;
                }
                VaultPortalTileEntity portalTE = (VaultPortalTileEntity)te;
                portalTE.setCrystalData(data.copy());
            });
            return true;
        }
        return false;
    }

    public static long getSeed(ItemStack stack) {
        if (!(stack.m_41720_() instanceof VaultCrystalItem)) {
            return 0L;
        }
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128425_("Seed", 4)) {
            VaultCrystalItem.setRandomSeed(stack);
        }
        return nbt.m_128454_("Seed");
    }

    public static void setRandomSeed(ItemStack stack) {
        if (!(stack.m_41720_() instanceof VaultCrystalItem)) {
            return;
        }
        stack.m_41784_().m_128356_("Seed", RANDOM.nextLong());
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        VaultCrystalItem.getData(stack).addInformation(world, tooltip, flag);
        super.m_7373_(stack, world, tooltip, flag);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (world.f_46443_ || hand == InteractionHand.OFF_HAND) {
            return super.m_7203_(world, player, hand);
        }
        ItemStack stack = player.m_21205_();
        CrystalData data = VaultCrystalItem.getData(stack);
        return super.m_7203_(world, player, hand);
    }

    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack itemStack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (this.hasScheduledTasks(itemStack)) {
                this.executeScheduledTasks(serverPlayer, itemStack);
                this.clearScheduledTasks(itemStack);
            }
        }
        super.m_6883_(itemStack, world, entity, itemSlot, isSelected);
    }

    public static void scheduleTask(IScheduledTask task, ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        CompoundTag scheduledTasks = nbt.m_128469_(KEY_SCHEDULED_TASKS);
        scheduledTasks.m_128365_(task.getId(), (Tag)task.serializeNBT());
        nbt.m_128365_(KEY_SCHEDULED_TASKS, (Tag)scheduledTasks);
    }

    private boolean hasScheduledTasks(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        return nbt.m_128441_(KEY_SCHEDULED_TASKS) && nbt.m_128469_(KEY_SCHEDULED_TASKS).m_128440_() > 0;
    }

    private void clearScheduledTasks(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        nbt.m_128473_(KEY_SCHEDULED_TASKS);
    }

    private void executeScheduledTasks(ServerPlayer serverPlayer, ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        CompoundTag scheduledTasks = nbt.m_128469_(KEY_SCHEDULED_TASKS);
        for (String key : scheduledTasks.m_128431_()) {
            IScheduledTaskDeserializer deserializer = SCHEDULED_TASK_DESERIALIZER_MAP.get(key);
            if (deserializer == null) {
                throw new IllegalStateException("Missing scheduled task deserializer registration for key [%s]".formatted(key));
            }
            deserializer.deserialize(scheduledTasks.m_128469_(key)).execute(serverPlayer, itemStack, VaultCrystalItem.getData(itemStack));
        }
        nbt.m_128473_(KEY_SCHEDULED_TASKS);
    }

    public static interface IScheduledTask {
        public static final CompoundTag EMPTY_COMPOUND_TAG = new CompoundTag();

        public String getId();

        public void execute(ServerPlayer var1, ItemStack var2, CrystalData var3);

        default public CompoundTag serializeNBT() {
            return EMPTY_COMPOUND_TAG;
        }
    }

    @FunctionalInterface
    public static interface IScheduledTaskDeserializer {
        public IScheduledTask deserialize(CompoundTag var1);
    }

    public record CloneTask(boolean success) implements IScheduledTask
    {
        public static final String ID = "clone";
        private static final String KEY_SUCCESS = "success";

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public void execute(ServerPlayer player, ItemStack itemStack, CrystalData data) {
            data.setModifiable(false);
            if (this.success) {
                itemStack.m_41784_().m_128379_(VaultCrystalItem.CLONED, true);
                EntityHelper.giveItem((Player)player, itemStack.m_41777_());
                player.m_20193_().m_5594_(null, player.m_142538_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 0.8f, 1.5f);
            } else {
                player.m_20193_().m_5594_(null, player.m_142538_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = IScheduledTask.super.serializeNBT();
            nbt.m_128379_(KEY_SUCCESS, this.success);
            return nbt;
        }

        public static CloneTask deserializeNBT(CompoundTag nbt) {
            return new CloneTask(nbt.m_128471_(KEY_SUCCESS));
        }
    }

    public record EchoTask(int amount) implements IScheduledTask
    {
        public static final String ID = "echo";
        private static final String KEY_AMOUNT = "amount";

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public void execute(ServerPlayer player, ItemStack itemStack, CrystalData data) {
            int remainder = data.addEchoGems(this.amount);
            if (remainder > 0) {
                EntityHelper.giveItem((Player)player, new ItemStack((ItemLike)ModItems.ECHO_GEM, remainder));
            }
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = IScheduledTask.super.serializeNBT();
            nbt.m_128405_(KEY_AMOUNT, this.amount);
            return nbt;
        }

        public static EchoTask deserializeNBT(CompoundTag nbt) {
            return new EchoTask(nbt.m_128451_(KEY_AMOUNT));
        }
    }

    public static class AddClarityTask
    implements IScheduledTask {
        public static final AddClarityTask INSTANCE = new AddClarityTask();
        public static final String ID = "addClarity";

        private AddClarityTask() {
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public void execute(ServerPlayer player, ItemStack itemStack, CrystalData data) {
            data.setClarity(true);
        }

        public static AddClarityTask deserializeNBT(CompoundTag nbt) {
            return INSTANCE;
        }
    }

    public static class RemoveRandomCurseTask
    implements IScheduledTask {
        public static final RemoveRandomCurseTask INSTANCE = new RemoveRandomCurseTask();
        public static final String ID = "removeRandomCurse";

        private RemoveRandomCurseTask() {
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public void execute(ServerPlayer player, ItemStack itemStack, CrystalData data) {
            data.removeRandomCurse(RANDOM);
        }

        public static RemoveRandomCurseTask deserializeNBT(CompoundTag nbt) {
            return INSTANCE;
        }
    }

    public record AddRandomCursesTask(int min, int max) implements IScheduledTask
    {
        public static final String ID = "addRandomCurses";
        private static final String KEY_MIN = "min";
        private static final String KEY_MAX = "max";

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public void execute(ServerPlayer player, ItemStack itemStack, CrystalData data) {
            int curses = RANDOM.nextInt(this.max - this.min + 1) + this.min;
            for (int i = 0; i < curses; ++i) {
                VaultCrystalCatalystConfig.ModifierPool pool = ModConfigs.VAULT_CRYSTAL_CATALYST.getModifierPoolById("CURSE");
                if (pool == null) continue;
                ResourceLocation curseModifier = pool.getRandomModifier(RANDOM);
                VaultModifierRegistry.getOpt(curseModifier).ifPresent(modifier -> data.addModifier(VaultModifierStack.of(modifier)));
            }
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = IScheduledTask.super.serializeNBT();
            nbt.m_128405_(KEY_MIN, this.min);
            nbt.m_128405_(KEY_MAX, this.max);
            return nbt;
        }

        public static AddRandomCursesTask deserializeNBT(CompoundTag nbt) {
            return new AddRandomCursesTask(nbt.m_128451_(KEY_MIN), nbt.m_128451_(KEY_MAX));
        }
    }

    public static class AddRandomCurseTask
    implements IScheduledTask {
        public static final AddRandomCurseTask INSTANCE = new AddRandomCurseTask();
        public static final String ID = "addRandomCurse";

        private AddRandomCurseTask() {
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public void execute(ServerPlayer player, ItemStack itemStack, CrystalData data) {
            VaultCrystalCatalystConfig.ModifierPool pool;
            if (Math.random() < (double)ModConfigs.VAULT_CRYSTAL.MODIFIER_STABILITY.calculateCurseChance(data.getInstability()) && (pool = ModConfigs.VAULT_CRYSTAL_CATALYST.getModifierPoolById("CURSE")) != null) {
                ResourceLocation curseModifier = pool.getRandomModifier(RANDOM);
                VaultModifierRegistry.getOpt(curseModifier).ifPresent(modifier -> data.addModifier(VaultModifierStack.of(modifier)));
            }
        }

        public static AddRandomCurseTask deserializeNBT(CompoundTag nbt) {
            return INSTANCE;
        }
    }

    public static class ExhaustTask
    implements IScheduledTask {
        public static final ExhaustTask INSTANCE = new ExhaustTask();
        public static final String ID = "exhaust";

        private ExhaustTask() {
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public void execute(ServerPlayer player, ItemStack itemStack, CrystalData data) {
            if (data.canBeModified() && Math.random() * 100.0 < (double)data.getInstability()) {
                data.setModifiable(false);
            }
        }

        public static ExhaustTask deserializeNBT(CompoundTag nbt) {
            return INSTANCE;
        }
    }
}

