/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item.crystal;

import iskallia.vault.VaultMod;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.crystal.CrystalModifiers;
import iskallia.vault.item.crystal.FrameData;
import iskallia.vault.item.crystal.layout.CrystalLayout;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import iskallia.vault.item.crystal.theme.CrystalTheme;
import iskallia.vault.item.crystal.theme.PoolCrystalTheme;
import iskallia.vault.util.MathUtilities;
import iskallia.vault.world.data.PlayerFavourData;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.builder.ClassicVaultBuilder;
import iskallia.vault.world.vault.builder.CoopVaultBuilder;
import iskallia.vault.world.vault.builder.FinalLobbyBuilder;
import iskallia.vault.world.vault.builder.RaffleVaultBuilder;
import iskallia.vault.world.vault.builder.TroveVaultBuilder;
import iskallia.vault.world.vault.builder.VaultRaidBuilder;
import iskallia.vault.world.vault.gen.VaultRoomNames;
import iskallia.vault.world.vault.logic.VaultLogic;
import iskallia.vault.world.vault.modifier.VaultModifierStack;
import iskallia.vault.world.vault.modifier.spi.VaultModifier;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;

public class CrystalData
implements INBTSerializable<CompoundTag> {
    public static final CrystalData EMPTY = new EmptyCrystalData();
    private CompoundTag delegate = new CompoundTag();
    protected UUID vaultId;
    protected int level;
    protected CrystalTheme theme;
    protected CrystalLayout layout;
    protected CrystalObjective objective;
    protected CrystalModifiers modifiers = new CrystalModifiers();
    protected Model model = Model.DEFAULT;
    protected Type type = Type.CLASSIC;
    protected boolean preventsRandomModifiers = false;
    protected boolean canBeModified = true;
    protected boolean canTriggerInfluences = true;
    protected boolean canGenerateTreasureRooms = true;
    protected List<String> guaranteedRoomFilters = new ArrayList<String>();
    protected EchoData echoData;
    protected FrameData frameData;
    protected int instabilityCounter;
    protected boolean clarity;

    public CrystalData() {
    }

    public CrystalData(CompoundTag delegate) {
        this.delegate = delegate;
        this.deserializeNBT(this.delegate.m_128469_("CrystalData"));
    }

    public CrystalData(ItemStack delegate) {
        if (delegate != null) {
            this.delegate = delegate.m_41784_();
            this.deserializeNBT(this.delegate.m_128469_("CrystalData"));
        }
    }

    public CompoundTag getDelegate() {
        return this.delegate;
    }

    public void updateDelegate() {
        if (this.delegate != null) {
            this.delegate.m_128365_("CrystalData", (Tag)this.serializeNBT());
        }
    }

    public UUID getVaultId() {
        return this.vaultId;
    }

    public CrystalData setVaultId(UUID uuid) {
        if (!uuid.equals(this.vaultId)) {
            this.vaultId = uuid;
            this.updateDelegate();
        }
        return this;
    }

    public int getLevel() {
        return this.level;
    }

    public CrystalData setLevel(int level) {
        if (level != this.level) {
            this.level = level;
            this.updateDelegate();
        }
        return this;
    }

    public CrystalTheme getTheme() {
        return this.theme;
    }

    public CrystalData setTheme(CrystalTheme theme) {
        if (!theme.equals(this.theme)) {
            this.theme = theme;
            this.updateDelegate();
        }
        return this;
    }

    public CrystalLayout getLayout() {
        return this.layout;
    }

    public CrystalData setLayout(CrystalLayout layout) {
        this.layout = layout;
        this.updateDelegate();
        return this;
    }

    public CrystalObjective getObjective() {
        return this.objective;
    }

    public CrystalData setObjective(CrystalObjective objective) {
        if (!objective.equals(this.objective)) {
            this.objective = objective;
            this.updateDelegate();
        }
        return this;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        if (this.model != model) {
            this.model = model;
            this.updateDelegate();
        }
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (this.type != type) {
            this.type = type;
            this.updateDelegate();
        }
    }

    public boolean canModifyWithCrafting() {
        if (!this.canBeModified()) {
            return false;
        }
        List<ResourceLocation> modifierNames = this.getModifiers().stream().map(VaultModifierStack::getModifierId).toList();
        if (modifierNames.contains(VaultMod.id("afterlife"))) {
            return false;
        }
        return this.getType().canCraft();
    }

    protected boolean canAddModifier(VaultModifierStack modifierStack) {
        return this.canBeModified();
    }

    public boolean addModifiersByCrafting(List<VaultModifierStack> modifierStackList, Simulate simulate) {
        for (VaultModifierStack modifierStack : modifierStackList) {
            if (this.addModifierByCrafting(modifierStack, true, Simulate.TRUE)) continue;
            return false;
        }
        if (simulate == Simulate.FALSE) {
            for (VaultModifierStack modifierStack : modifierStackList) {
                this.addModifierByCrafting(modifierStack, true, simulate);
            }
        }
        return true;
    }

    public boolean addModifierByCrafting(VaultModifierStack modifierStack, boolean preventsRandomModifiers, Simulate simulate) {
        if (!this.canModifyWithCrafting() || !this.canAddModifier(modifierStack)) {
            return false;
        }
        if (simulate == Simulate.FALSE) {
            if (preventsRandomModifiers) {
                this.setPreventsRandomModifiers(true);
            }
            ++this.instabilityCounter;
            this.addModifier(modifierStack);
        }
        return true;
    }

    public void addModifier(VaultModifierStack modifierStack) {
        if (modifierStack.isEmpty()) {
            VaultMod.LOGGER.error("Attempted to add Empty modifier to crystal. If you see this stacktrace, please share it with the devs.", (Throwable)new Exception());
            return;
        }
        boolean found = false;
        ResourceLocation modifierId = modifierStack.getModifierId();
        for (VaultModifierStack modifier : this.modifiers) {
            if (!modifier.getModifierId().equals((Object)modifierId)) continue;
            modifier.grow(modifierStack.getSize());
            found = true;
            break;
        }
        if (!found) {
            this.modifiers.add(modifierStack.copy());
        }
        this.sortModifiers();
        this.updateDelegate();
    }

    private void sortModifiers() {
        this.modifiers.sort(Comparator.comparing(VaultModifierStack::getSize).reversed());
    }

    public void setInstabilityCounter(int value) {
        this.instabilityCounter = Math.max(0, value);
        this.updateDelegate();
    }

    public int getInstability() {
        if (ModConfigs.VAULT_CRYSTAL == null) {
            return 0;
        }
        int craftsBeforeInstability = ModConfigs.VAULT_CRYSTAL.MODIFIER_STABILITY.craftsBeforeInstability;
        float instabilityPerCraft = ModConfigs.VAULT_CRYSTAL.MODIFIER_STABILITY.instabilityPerCraft;
        float instabilityCap = ModConfigs.VAULT_CRYSTAL.MODIFIER_STABILITY.instabilityCap;
        int instability = this.instabilityCounter - craftsBeforeInstability;
        if (instability < 1) {
            return 0;
        }
        return (int)(Math.min((float)instability * instabilityPerCraft, instabilityCap) * 100.0f);
    }

    private TextColor getInstabilityTextColor(int instability) {
        float value;
        float saturation;
        float hue;
        float threshold = ModConfigs.VAULT_CRYSTAL.MODIFIER_STABILITY.instabilityCap * 0.5f;
        float instabilityScaled = (float)instability * 0.01f;
        float hueDarkGreen = 0.3334f;
        float hueGold = 0.1111f;
        if (instabilityScaled <= threshold) {
            float p = instabilityScaled / threshold;
            hue = (1.0f - p) * 0.3334f + p * 0.1111f;
            saturation = 1.0f;
            value = (1.0f - p) * 0.8f + p;
        } else {
            float p = (instabilityScaled - threshold) / threshold;
            hue = (1.0f - p) * 0.1111f;
            saturation = 1.0f - p + p * 0.8f;
            value = 1.0f - p + p * 0.8f;
        }
        return TextColor.m_131266_((int)Color.HSBtoRGB(hue, saturation, value));
    }

    public List<VaultModifierStack> getModifiers() {
        return Collections.unmodifiableList(this.modifiers);
    }

    public void setModifiers(CrystalModifiers modifiers) {
        this.modifiers.clear();
        this.modifiers.addAll(modifiers);
        this.sortModifiers();
        this.updateDelegate();
    }

    public void clearModifiers() {
        this.modifiers.clear();
        this.updateDelegate();
    }

    public boolean canAddRoom(String roomKey) {
        return true;
    }

    public void addGuaranteedRoom(String roomKey) {
        this.guaranteedRoomFilters.add(roomKey);
        this.updateDelegate();
    }

    public List<String> getGuaranteedRoomFilters() {
        return Collections.unmodifiableList(this.guaranteedRoomFilters);
    }

    public boolean preventsRandomModifiers() {
        if (!this.canBeModified()) {
            return true;
        }
        return this.preventsRandomModifiers || !this.getType().canGenerateRandomModifiers();
    }

    public void setPreventsRandomModifiers(boolean preventsRandomModifiers) {
        this.preventsRandomModifiers = preventsRandomModifiers;
        this.updateDelegate();
    }

    public boolean canTriggerInfluences() {
        return this.canTriggerInfluences;
    }

    public void setCanTriggerInfluences(boolean canTriggerInfluences) {
        this.canTriggerInfluences = canTriggerInfluences;
        this.updateDelegate();
    }

    public boolean canGenerateTreasureRooms() {
        return this.canGenerateTreasureRooms;
    }

    public void setCanGenerateTreasureRooms(boolean canGenerateTreasureRooms) {
        this.canGenerateTreasureRooms = canGenerateTreasureRooms;
        this.updateDelegate();
    }

    public boolean canBeModified() {
        return this.canBeModified;
    }

    public void setModifiable(boolean modifiable) {
        this.canBeModified = modifiable;
        this.updateDelegate();
    }

    public int getCurseCount() {
        return this.modifiers.stream().filter(vaultModifierStack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isCurse(vaultModifierStack.getModifierId())).map(VaultModifierStack::getSize).reduce(0, Integer::sum);
    }

    public boolean isCursed() {
        return this.getCurseCount() > 0;
    }

    public void setClarity(boolean clarity) {
        this.clarity = clarity;
        this.updateDelegate();
    }

    public boolean hasClarity() {
        return this.clarity;
    }

    public void removeAllCurses() {
        this.modifiers.removeIf(vaultModifierStack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isCurse(vaultModifierStack.getModifierId()));
        this.updateDelegate();
    }

    public void removeRandomCurse(Random random) {
        List<VaultModifierStack> curseList = this.modifiers.stream().filter(vaultModifierStack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isCurse(vaultModifierStack.getModifierId())).toList();
        if (curseList.isEmpty()) {
            return;
        }
        VaultModifierStack modifierStack = curseList.get(random.nextInt(curseList.size()));
        if (modifierStack.shrink(1).isEmpty()) {
            this.modifiers.remove(modifierStack);
        }
        this.updateDelegate();
    }

    public void apply(VaultRaid vault) {
        vault.getModifiers().addPermanentModifiers(this.modifiers);
    }

    public VaultRaid.Builder createVault(ServerLevel world, ServerPlayer player) {
        return this.getType().getVaultBuilder().initializeBuilder(world, player, this);
    }

    public static boolean shouldForceCowVault(CrystalData data) {
        List<ResourceLocation> requiredModifiers = Arrays.asList(VaultMod.id("hoard"), VaultMod.id("hunger"), VaultMod.id("raging"));
        List<VaultModifierStack> existingModifiers = data.getModifiers();
        return existingModifiers.size() == 3 && existingModifiers.stream().allMatch(modifier -> requiredModifiers.contains(modifier.getModifierId()));
    }

    public EchoData getEchoData() {
        if (this.echoData == null) {
            this.echoData = new EchoData(0);
        }
        return this.echoData;
    }

    public FrameData getFrameData() {
        return this.frameData;
    }

    public int addEchoGems(int amount) {
        int remainder = this.getEchoData().addEchoGems(amount);
        this.updateDelegate();
        return remainder;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addInformation(Level world, List<Component> tooltip, TooltipFlag flag) {
        int curseCount;
        tooltip.add((Component)new TextComponent("Level: ").m_7220_((Component)new TextComponent("" + this.getLevel()).m_6270_(Style.f_131099_.m_178520_(11583738))));
        Type crystalType = this.getType();
        if (crystalType.showTypePrefix()) {
            // empty if block
        }
        if (this.objective == null) {
            tooltip.add((Component)new TextComponent("Objective: ???").m_130940_(ChatFormatting.GRAY));
        } else {
            this.objective.addText(tooltip, flag);
        }
        if (this.theme == null || this.theme instanceof PoolCrystalTheme) {
            tooltip.add((Component)new TextComponent("Theme: ???").m_130940_(ChatFormatting.GRAY));
        } else {
            this.theme.addText(tooltip, flag);
        }
        if (this.layout == null) {
            tooltip.add((Component)new TextComponent("Layout: ???").m_130940_(ChatFormatting.GRAY));
        } else {
            this.layout.addText(tooltip, flag);
        }
        HashMap<String, Integer> collapsedFilters = new HashMap<String, Integer>();
        for (String roomFilter2 : this.guaranteedRoomFilters) {
            int count2 = collapsedFilters.getOrDefault(roomFilter2, 0);
            collapsedFilters.put(roomFilter2, ++count2);
        }
        collapsedFilters.forEach((roomFilter, count) -> {
            Component roomName = VaultRoomNames.getName(roomFilter);
            if (roomName == null) {
                return;
            }
            String roomStr = count > 1 ? "Rooms" : "Room";
            MutableComponent txt = new TextComponent("- Has ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.valueOf(count)).m_130940_(ChatFormatting.GOLD)).m_130946_(" ").m_7220_(roomName).m_7220_((Component)new TextComponent(" " + roomStr).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)txt);
        });
        int instability = this.getInstability();
        if (instability > 0) {
            TextComponent instabilityComponent = new TextComponent(instability + "%");
            instabilityComponent.m_6270_(Style.f_131099_.m_131148_(this.getInstabilityTextColor(instability)));
            tooltip.add((Component)new TextComponent("Instability: ").m_7220_((Component)instabilityComponent));
        }
        if (this.getEchoData().getEchoCount() > 0) {
            int count3 = this.getEchoData().getEchoCount();
            tooltip.add((Component)new TextComponent("Echoed").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)2491465))));
            if (Screen.m_96638_()) {
                MutableComponent description = new TextComponent("  " + count3 + "% Echo Rate").m_130940_(ChatFormatting.DARK_GRAY);
                tooltip.add((Component)description);
            }
        }
        if (!this.canBeModified()) {
            tooltip.add((Component)new TextComponent("Exhausted").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)3084959))));
            if (Screen.m_96638_()) {
                MutableComponent description = new TextComponent("  Crystal can not be modified.").m_130940_(ChatFormatting.DARK_GRAY);
                tooltip.add((Component)description);
            }
        }
        if (this.delegate.m_128471_("Cloned")) {
            tooltip.add((Component)new TextComponent("Cloned").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)2491465))));
            if (Screen.m_96638_()) {
                MutableComponent description = new TextComponent("  Crystal has been cloned with an Echoed Crystal.").m_130940_(ChatFormatting.DARK_GRAY);
                tooltip.add((Component)description);
            }
        }
        if (this.hasClarity()) {
            tooltip.add((Component)new TextComponent("Clarity").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)4973509))));
            if (Screen.m_96638_()) {
                MutableComponent description = new TextComponent("  All curses on this crystal are revealed.").m_130940_(ChatFormatting.DARK_GRAY);
                tooltip.add((Component)description);
            }
        }
        if ((curseCount = this.getCurseCount()) > 0) {
            Style style = Style.f_131099_.m_131148_(ModConfigs.VAULT_CRYSTAL.MODIFIER_STABILITY.curseColor);
            if (this.hasClarity()) {
                this.addCatalystModifierInformation(vaultModifierStack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isCurse(vaultModifierStack.getModifierId()), (Component)new TextComponent("Cursed").m_130948_(style), tooltip);
            } else {
                MutableComponent component = new TextComponent("Cursed ").m_130948_(style);
                tooltip.add((Component)component.m_130946_("\u2620".repeat(curseCount)));
            }
        }
        this.addCatalystModifierInformation(vaultModifierStack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isGood(vaultModifierStack.getModifierId()), (Component)new TextComponent("Positive Modifiers").m_130940_(ChatFormatting.GREEN), tooltip);
        this.addCatalystModifierInformation(vaultModifierStack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isBad(vaultModifierStack.getModifierId()), (Component)new TextComponent("Negative Modifiers").m_130940_(ChatFormatting.RED), tooltip);
        this.addNonCatalystModifierInformation(vaultModifierStack -> ModConfigs.VAULT_CRYSTAL_CATALYST.isUnlisted(vaultModifierStack.getModifierId()), (Component)new TextComponent("Other Modifiers").m_130940_(ChatFormatting.WHITE), tooltip);
    }

    private void addNonCatalystModifierInformation(Predicate<VaultModifierStack> filter, Component headerComponent, List<Component> tooltip) {
        List<VaultModifierStack> modifierList = this.modifiers.stream().filter(filter).toList();
        if (!modifierList.isEmpty()) {
            tooltip.add(headerComponent);
            for (VaultModifierStack modifierStack : modifierList) {
                VaultModifier<?> vaultModifier = modifierStack.getModifier();
                TextComponent modifierName = new TextComponent(vaultModifier.getDisplayNameFormatted(modifierStack.getSize()));
                modifierName.m_6270_(Style.f_131099_.m_131148_(vaultModifier.getDisplayTextColor()));
                tooltip.add((Component)new TextComponent("  ").m_7220_((Component)modifierName));
                if (!Screen.m_96638_()) continue;
                MutableComponent description = new TextComponent("  " + vaultModifier.getDisplayDescriptionFormatted(modifierStack.getSize())).m_130940_(ChatFormatting.DARK_GRAY);
                tooltip.add((Component)description);
            }
        }
    }

    private void addCatalystModifierInformation(Predicate<VaultModifierStack> filter, Component headerComponent, List<Component> tooltip) {
        List<VaultModifierStack> modifierList = this.modifiers.stream().filter(filter).toList();
        if (!modifierList.isEmpty()) {
            tooltip.add(headerComponent);
            for (VaultModifierStack modifierStack : modifierList) {
                VaultModifier<?> vaultModifier = modifierStack.getModifier();
                TextComponent modifierName = new TextComponent(vaultModifier.getDisplayNameFormatted(modifierStack.getSize()));
                modifierName.m_6270_(Style.f_131099_.m_131148_(vaultModifier.getDisplayTextColor()));
                MutableComponent stackSize = new TextComponent("%dx".formatted(modifierStack.getSize())).m_130940_(ChatFormatting.GRAY);
                tooltip.add((Component)new TextComponent("  ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)stackSize).m_130946_(" ").m_7220_((Component)modifierName));
                if (!Screen.m_96638_()) continue;
                MutableComponent description = new TextComponent("  " + vaultModifier.getDisplayDescriptionFormatted(modifierStack.getSize())).m_130940_(ChatFormatting.DARK_GRAY);
                tooltip.add((Component)description);
            }
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.vaultId != null) {
            nbt.m_128359_("VaultId", this.vaultId.toString());
        }
        nbt.m_128405_("Level", this.level);
        if (this.theme != null) {
            nbt.m_128365_("Theme", this.theme.serializeNBT());
        }
        if (this.layout != null) {
            nbt.m_128365_("Layout", this.layout.serializeNBT());
        }
        if (this.objective != null) {
            nbt.m_128365_("Objective", this.objective.serializeNBT());
        }
        nbt.m_128365_("Modifiers", (Tag)this.modifiers.serializeNBT());
        nbt.m_128344_("Model", this.model.serializedId);
        nbt.m_128359_("Type", this.type.name());
        nbt.m_128379_("preventsRandomModifiers", this.preventsRandomModifiers);
        nbt.m_128379_("canBeModified", this.canBeModified);
        nbt.m_128379_("canTriggerInfluences", this.canTriggerInfluences);
        nbt.m_128379_("canGenerateTreasureRooms", this.canGenerateTreasureRooms);
        nbt.m_128365_("echoData", (Tag)this.getEchoData().toNBT());
        ListTag roomList = new ListTag();
        this.guaranteedRoomFilters.forEach(roomKey -> roomList.add((Object)StringTag.m_129297_((String)roomKey)));
        nbt.m_128365_("rooms", (Tag)roomList);
        if (this.frameData != null) {
            nbt.m_128365_("Frame", (Tag)this.frameData.serializeNBT());
        }
        nbt.m_128405_("instabilityCounter", this.instabilityCounter);
        nbt.m_128379_("clarity", this.clarity);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.vaultId = nbt.m_128425_("VaultId", 8) ? UUID.fromString(nbt.m_128461_("VaultId")) : null;
        this.level = nbt.m_128451_("Level");
        this.theme = nbt.m_128425_("Theme", 10) ? CrystalTheme.fromNBT(nbt.m_128469_("Theme")) : null;
        this.layout = nbt.m_128425_("Layout", 10) ? CrystalLayout.fromNBT(nbt.m_128469_("Layout")) : null;
        this.objective = nbt.m_128425_("Objective", 10) ? CrystalObjective.fromNBT(nbt.m_128469_("Objective")) : null;
        this.modifiers.deserializeNBT(nbt.m_128437_("Modifiers", 10));
        this.sortModifiers();
        this.model = nbt.m_128425_("Model", 1) ? Model.fromSerializedId(nbt.m_128445_("Model")) : Model.DEFAULT;
        Type type = this.type = nbt.m_128425_("Type", 8) ? Enum.valueOf(Type.class, nbt.m_128461_("Type")) : Type.CLASSIC;
        if (this.type == Type.COOP) {
            this.type = Type.CLASSIC;
        }
        this.preventsRandomModifiers = nbt.m_128425_("preventsRandomModifiers", 1) ? nbt.m_128471_("preventsRandomModifiers") : !this.modifiers.isEmpty();
        this.canBeModified = !nbt.m_128425_("canBeModified", 1) || nbt.m_128471_("canBeModified");
        this.canTriggerInfluences = !nbt.m_128425_("canTriggerInfluences", 1) || nbt.m_128471_("canTriggerInfluences");
        boolean bl = this.canGenerateTreasureRooms = !nbt.m_128425_("canGenerateTreasureRooms", 1) || nbt.m_128471_("canGenerateTreasureRooms");
        if (nbt.m_128441_("echoData")) {
            this.echoData = EchoData.fromNBT(nbt.m_128469_("echoData"));
        }
        ListTag roomList = nbt.m_128437_("rooms", 8);
        roomList.forEach(inbt -> this.guaranteedRoomFilters.add(this.migrateRoomName(inbt.m_7916_())));
        this.frameData = FrameData.fromNBT(nbt.m_128469_("Frame"));
        this.instabilityCounter = nbt.m_128451_("instabilityCounter");
        this.clarity = nbt.m_128471_("clarity");
    }

    private String migrateRoomName(String roomName) {
        if (roomName.equalsIgnoreCase("contest")) {
            roomName = "contest_tree";
        }
        return roomName;
    }

    public CrystalData copy() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("CrystalData", (Tag)this.serializeNBT());
        return new CrystalData(nbt);
    }

    public static enum Model {
        DEFAULT(0),
        RAW(1);

        private final byte serializedId;
        private static Map<Byte, Model> MAP;

        private Model(byte serializedId) {
            this.serializedId = serializedId;
        }

        public byte getSerializedId() {
            return this.serializedId;
        }

        public static Model fromSerializedId(byte serializedId) {
            return MAP.getOrDefault(serializedId, DEFAULT);
        }

        static {
            MAP = Arrays.stream(Model.values()).collect(Collectors.toMap(Model::getSerializedId, m -> m));
        }
    }

    public static enum Type {
        CLASSIC(VaultLogic.COOP, CoopVaultBuilder.getInstance(), "Normal"),
        RAFFLE(VaultLogic.RAFFLE, RaffleVaultBuilder.getInstance(), "Raffle"),
        COOP(VaultLogic.COOP, CoopVaultBuilder.getInstance(), "Cooperative"),
        TROVE(VaultLogic.CLASSIC, TroveVaultBuilder.getInstance(), "Vault Trove", ChatFormatting.GOLD),
        BOSS_BENEVOLENT_PREP("Velara's Sacrifice", PlayerFavourData.VaultGodType.BENEVOLENT.getChatColor()),
        BOSS_BENEVOLENT("Velara's Demand", PlayerFavourData.VaultGodType.BENEVOLENT.getChatColor()),
        BOSS_OMNISCIENT("Tenos' Oblivion", PlayerFavourData.VaultGodType.OMNISCIENT.getChatColor()),
        BOSS_TIMEKEEPER("Wendarr's Transience", PlayerFavourData.VaultGodType.TIMEKEEPER.getChatColor()),
        BOSS_MALEVOLENCE("Idona's Wrath", PlayerFavourData.VaultGodType.MALEVOLENT.getChatColor()),
        FINAL_LOBBY(VaultLogic.FINAL_LOBBY, FinalLobbyBuilder.getInstance(), "Final Vault", ChatFormatting.DARK_PURPLE),
        FINAL_VELARA(VaultLogic.COOP, CoopVaultBuilder.getInstance(), "Final Velara Challenge", ChatFormatting.GREEN),
        FINAL_TENOS(VaultLogic.COOP, CoopVaultBuilder.getInstance(), "Final Tenos Challenge", ChatFormatting.AQUA),
        FINAL_WENDARR(VaultLogic.COOP, CoopVaultBuilder.getInstance(), "Final Wendarr Challenge", ChatFormatting.GOLD),
        FINAL_IDONA(VaultLogic.COOP, CoopVaultBuilder.getInstance(), "Final Idona Challenge", ChatFormatting.RED);

        private final VaultLogic logic;
        private final VaultRaidBuilder vaultBuilder;
        private final String name;
        private final ChatFormatting color;

        private Type(String name, ChatFormatting color) {
            this(VaultLogic.CLASSIC, ClassicVaultBuilder.getInstance(), name, color);
        }

        private Type(VaultLogic logic, VaultRaidBuilder vaultBuilder, String name) {
            this(logic, vaultBuilder, name, ChatFormatting.GOLD);
        }

        private Type(VaultLogic logic, VaultRaidBuilder vaultBuilder, String name, ChatFormatting color) {
            this.logic = logic;
            this.vaultBuilder = vaultBuilder;
            this.name = name;
            this.color = color;
        }

        public boolean canCraft() {
            return this == CLASSIC || this == COOP;
        }

        public boolean showTypePrefix() {
            return this == CLASSIC || this == RAFFLE || this == COOP;
        }

        public boolean showObjective() {
            return this == CLASSIC || this == RAFFLE || this == COOP;
        }

        public boolean visibleInCreative() {
            return this == RAFFLE || this == COOP || this == TROVE || this == FINAL_LOBBY;
        }

        public boolean canBeCowVault() {
            return this == CLASSIC || this == RAFFLE || this == COOP;
        }

        public boolean canGenerateRandomModifiers() {
            return this == CLASSIC || this == RAFFLE || this == COOP || this == FINAL_VELARA || this == FINAL_IDONA || this == FINAL_WENDARR || this == FINAL_TENOS;
        }

        public boolean canTriggerInfluences() {
            return this == CLASSIC || this == COOP;
        }

        public VaultLogic getLogic() {
            return this.logic;
        }

        public VaultRaidBuilder getVaultBuilder() {
            return this.vaultBuilder;
        }

        public Component getDisplayName() {
            return new TextComponent(this.name).m_130940_(this.color);
        }
    }

    public static enum Simulate {
        TRUE,
        FALSE;

    }

    public static class EchoData {
        int echoCount;

        public EchoData(int echoCount) {
            this.echoCount = echoCount;
        }

        public int getEchoCount() {
            return this.echoCount;
        }

        public int addEchoGems(int amount) {
            if (this.echoCount >= 100) {
                return amount;
            }
            for (int i = amount; i > 0; --i) {
                if (this.echoCount >= 100) {
                    return i;
                }
                if (!(MathUtilities.randomFloat(0.0f, 1.0f) < this.getEchoSuccessRate())) continue;
                ++this.echoCount;
            }
            return 0;
        }

        public float getCloneSuccessRate() {
            return (float)this.echoCount / 100.0f;
        }

        public float getEchoSuccessRate() {
            return (float)(100 - this.echoCount) / 100.0f;
        }

        public CompoundTag toNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("echoCount", this.echoCount);
            return nbt;
        }

        public static EchoData fromNBT(CompoundTag nbt) {
            return new EchoData(nbt.m_128451_("echoCount"));
        }
    }

    private static class EmptyCrystalData
    extends CrystalData {
        private EmptyCrystalData() {
        }

        @Override
        public boolean addModifierByCrafting(VaultModifierStack modifierStack, boolean preventsRandomModifiers, Simulate simulate) {
            return false;
        }

        @Override
        protected boolean canAddModifier(VaultModifierStack id) {
            return false;
        }

        @Override
        public boolean preventsRandomModifiers() {
            return false;
        }

        @Override
        public void setType(Type type) {
        }

        @Override
        public VaultRaid.Builder createVault(ServerLevel world, ServerPlayer player) {
            return null;
        }
    }
}

