/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.util.MathUtilities;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class VaultXPFoodItem
extends Item {
    public static FoodProperties FOOD = new FoodProperties.Builder().m_38758_(0.0f).m_38760_(0).m_38766_().m_38765_().m_38767_();
    private final int levelLimit;

    public VaultXPFoodItem(ResourceLocation id, Item.Properties properties) {
        this(id, properties, -1);
    }

    public VaultXPFoodItem(ResourceLocation id, Item.Properties properties, int levelLimit) {
        super(properties.m_41489_(FOOD));
        this.setRegistryName(id);
        this.levelLimit = levelLimit;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return super.m_6164_(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        int vaultLevel;
        if (this.levelLimit > 0 && (vaultLevel = player instanceof ServerPlayer ? PlayerVaultStatsData.get(((ServerPlayer)player).m_183503_()).getVaultStats(player).getVaultLevel() : this.getVaultLevel()) >= this.levelLimit) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        return super.m_7203_(world, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getVaultLevel() {
        return VaultBarOverlay.vaultLevel;
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entityLiving) {
        if (!world.f_46443_ && entityLiving instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entityLiving;
            this.grantExp(player);
        }
        return super.m_5922_(stack, world, entityLiving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.levelLimit > 0) {
            tooltip.add(TextComponent.f_131282_);
            tooltip.add((Component)new TextComponent("Can't be consumed after Level: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.valueOf(this.levelLimit)).m_130940_(ChatFormatting.AQUA)));
        }
    }

    public abstract void grantExp(ServerPlayer var1);

    public static class Flat
    extends VaultXPFoodItem {
        private final Supplier<Integer> min;
        private final Supplier<Integer> max;

        public Flat(ResourceLocation id, Supplier<Integer> min, Supplier<Integer> max, Item.Properties properties) {
            this(id, min, max, properties, -1);
        }

        public Flat(ResourceLocation id, Supplier<Integer> min, Supplier<Integer> max, Item.Properties properties, int levelRequirement) {
            super(id, properties, levelRequirement);
            this.min = min;
            this.max = max;
        }

        @Override
        public void grantExp(ServerPlayer sPlayer) {
            PlayerVaultStatsData statsData = PlayerVaultStatsData.get(sPlayer.m_183503_());
            statsData.addVaultExp(sPlayer, MathUtilities.getRandomInt(this.min.get(), this.max.get()));
        }
    }
}

