/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.generator.layout.DIYRoomEntry;
import iskallia.vault.core.world.loot.LootRoll;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.gear.VaultLootItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VaultRuneItem
extends Item
implements VaultLootItem {
    public VaultRuneItem(CreativeModeTab group, ResourceLocation id) {
        super(new Item.Properties().m_41491_(group).m_41487_(8));
        this.setRegistryName(id);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            this.addStack(items, DIYRoomEntry.ofType(DIYRoomEntry.Type.COMMON, 1));
            this.addStack(items, DIYRoomEntry.ofType(DIYRoomEntry.Type.CHALLENGE, 1));
            this.addStack(items, DIYRoomEntry.ofType(DIYRoomEntry.Type.OMEGA, 1));
        }
    }

    public void addStack(NonNullList<ItemStack> items, DIYRoomEntry ... entries) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.RUNE);
        ListTag list = new ListTag();
        for (DIYRoomEntry entry : entries) {
            list.add((Object)entry.serializeNBT());
        }
        stack.m_41784_().m_128365_("entries", (Tag)list);
        items.add((Object)stack);
    }

    public static List<DIYRoomEntry> getEntries(ItemStack stack) {
        ArrayList<DIYRoomEntry> entries = new ArrayList<DIYRoomEntry>();
        if (stack.m_41783_() != null) {
            ListTag list = stack.m_41783_().m_128437_("entries", 10);
            for (int i = 0; i < list.size(); ++i) {
                entries.add(DIYRoomEntry.fromNBT(list.m_128728_(i)));
            }
        }
        return entries;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        for (DIYRoomEntry entry : VaultRuneItem.getEntries(stack)) {
            int count = entry.get(DIYRoomEntry.COUNT);
            String roomStr = count > 1 ? "Rooms" : "Room";
            MutableComponent txt = new TextComponent("- Has ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.valueOf(count)).m_130940_(ChatFormatting.GOLD)).m_130946_(" ").m_7220_(entry.getName()).m_7220_((Component)new TextComponent(" " + roomStr).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)txt);
        }
    }

    @Override
    public void initializeLoot(Vault vault, ItemStack stack) {
        if (stack.m_41783_() == null) {
            return;
        }
        ListTag list = stack.m_41783_().m_128437_("entries", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            if (!entry.m_128425_("count", 10)) continue;
            LootRoll roll = LootRoll.fromNBT(entry.m_128469_("count"));
            JavaRandom random = JavaRandom.ofNanoTime();
            entry.m_128405_("count", roll.get(random));
        }
    }
}

