/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.config.VaultCrystalCatalystConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.CodecUtils;
import iskallia.vault.world.vault.modifier.modifier.PlayerInventoryRestoreModifier;
import iskallia.vault.world.vault.modifier.registry.VaultModifierRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class VaultCatalystInfusedItem
extends Item {
    private static final String TOOLTIP_MODIFIER_SINGULAR = "tooltip.the_vault.vault_catalyst.modifier.singular";
    private static final String TOOLTIP_MODIFIER_PLURAL = "tooltip.the_vault.vault_catalyst.modifier.plural";
    private static final String TOOLTIP_MODIFIER_NAME_PREFIX = "- ";
    private static final String TOOLTIP_MODIFIER_DESCRIPTION_PREFIX = "   ";
    private static final String TAG_MODIFIERS = "modifiers";
    private static final Random RANDOM = new Random();

    public VaultCatalystInfusedItem(CreativeModeTab group, ResourceLocation id) {
        super(new Item.Properties().m_41491_(group).m_41487_(1));
        this.setRegistryName(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        List<ResourceLocation> modifierIdList = VaultCatalystInfusedItem.getModifiers(itemStack);
        if (modifierIdList.isEmpty()) {
            return;
        }
        tooltip.add(TextComponent.f_131282_);
        tooltip.add((Component)new TranslatableComponent(modifierIdList.size() <= 1 ? TOOLTIP_MODIFIER_SINGULAR : TOOLTIP_MODIFIER_PLURAL).m_130940_(ChatFormatting.GOLD));
        for (ResourceLocation modifierId : modifierIdList) {
            VaultModifierRegistry.getOpt(modifierId).ifPresent(vaultModifier -> {
                tooltip.add((Component)new TextComponent(TOOLTIP_MODIFIER_NAME_PREFIX + vaultModifier.getDisplayName()).m_130948_(Style.f_131099_.m_131148_(vaultModifier.getDisplayTextColor())));
                if (Screen.m_96638_()) {
                    tooltip.add((Component)new TextComponent(TOOLTIP_MODIFIER_DESCRIPTION_PREFIX + vaultModifier.getDisplayDescription()).m_130940_(ChatFormatting.DARK_GRAY));
                }
            });
        }
    }

    public static void initializeModifiers(ItemStack itemStack, boolean casualVaults) {
        if (!VaultCatalystInfusedItem.hasModifiers(itemStack)) {
            VaultCatalystInfusedItem.randomizeModifiers(itemStack, casualVaults);
        }
    }

    public boolean m_5812_(ItemStack itemStack) {
        return itemStack.m_41720_() == ModItems.VAULT_CATALYST_INFUSED;
    }

    private static void randomizeModifiers(ItemStack itemStack, boolean casualVaults) {
        if (itemStack.m_41720_() != ModItems.VAULT_CATALYST_INFUSED) {
            return;
        }
        VaultCrystalCatalystConfig.ModifierPoolGroup modifierPoolGroup = ModConfigs.VAULT_CRYSTAL_CATALYST.getRandomModifierPoolGroup(RANDOM);
        if (modifierPoolGroup == null) {
            return;
        }
        List<ResourceLocation> modifierIdList = modifierPoolGroup.getModifierPoolIdList().stream().map(modifierPoolId -> ModConfigs.VAULT_CRYSTAL_CATALYST.getModifierPoolById((String)modifierPoolId)).filter(Objects::nonNull).map(modifierPool -> modifierPool.getRandomModifier(RANDOM, modifierId -> casualVaults && VaultCatalystInfusedItem.isInventoryRestoreModifier(modifierId))).collect(Collectors.toList());
        VaultCatalystInfusedItem.setModifiers(itemStack, modifierIdList);
    }

    private static boolean isInventoryRestoreModifier(ResourceLocation modifierId) {
        return VaultModifierRegistry.get(modifierId) instanceof PlayerInventoryRestoreModifier;
    }

    private static boolean hasModifiers(ItemStack itemStack) {
        if (itemStack.m_41720_() != ModItems.VAULT_CATALYST_INFUSED) {
            return false;
        }
        CompoundTag tag = itemStack.m_41784_();
        return tag.m_128425_(TAG_MODIFIERS, 9);
    }

    public static List<ResourceLocation> getModifiers(ItemStack itemStack) {
        if (itemStack.m_41720_() != ModItems.VAULT_CATALYST_INFUSED) {
            return Collections.emptyList();
        }
        CompoundTag tag = itemStack.m_41784_();
        return CodecUtils.readNBT(ResourceLocation.f_135803_.listOf(), (Tag)tag.m_128437_(TAG_MODIFIERS, 8)).orElse(Collections.emptyList());
    }

    private static void setModifiers(ItemStack itemStack, List<ResourceLocation> result) {
        if (itemStack.m_41720_() != ModItems.VAULT_CATALYST_INFUSED) {
            return;
        }
        CompoundTag tag = itemStack.m_41784_();
        CodecUtils.writeNBT(ResourceLocation.f_135803_.listOf(), result, nbt -> tag.m_128365_(TAG_MODIFIERS, nbt));
    }
}

