/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.MathUtilities;
import iskallia.vault.world.data.ServerVaults;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemVaultFruit
extends Item {
    public static FoodProperties VAULT_FRUIT_FOOD = new FoodProperties.Builder().m_38758_(0.0f).m_38760_(0).m_38766_().m_38765_().m_38767_();
    protected int extraVaultTicks;

    public ItemVaultFruit(CreativeModeTab group, ResourceLocation id, int extraVaultTicks) {
        super(new Item.Properties().m_41491_(group).m_41489_(VAULT_FRUIT_FOOD).m_41487_(64));
        this.setRegistryName(id);
        this.extraVaultTicks = extraVaultTicks;
    }

    public boolean onEaten(Level world, Player player) {
        CommonEvents.FRUIT_EATEN.invoke(this, player, this.extraVaultTicks);
        return true;
    }

    public int getExtraVaultTicks() {
        return this.extraVaultTicks;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!ServerVaults.isVaultWorld(level)) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        return super.m_7203_(level, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TextComponent(""));
        TextComponent comp = new TextComponent("[!] Only edible inside a Vault");
        comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)).m_131155_(Boolean.valueOf(true)));
        tooltip.add((Component)comp);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public Component m_7626_(ItemStack stack) {
        MutableComponent displayName = (MutableComponent)super.m_7626_(stack);
        return displayName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16563456)));
    }

    public static class SweetKiwi
    extends ItemVaultFruit {
        public SweetKiwi(CreativeModeTab group, ResourceLocation id, int extraVaultTicks) {
            super(group, id, extraVaultTicks);
        }

        public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
            if (!worldIn.f_46443_ && entityLiving instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entityLiving;
                if (this.onEaten(worldIn, (Player)player)) {
                    worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11767_, SoundSource.MASTER, 1.0f, 1.0f);
                } else {
                    return stack;
                }
            }
            return super.m_5922_(stack, worldIn, entityLiving);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
            tooltip.add((Component)new TextComponent(""));
            TextComponent comp = new TextComponent("- Adds 5 seconds to the Vault Timer");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)65280)));
            tooltip.add((Component)comp);
            super.m_7373_(stack, worldIn, tooltip, flagIn);
        }
    }

    public static class MysticPear
    extends ItemVaultFruit {
        protected DamageSource damageSource = new DamageSource("mystic_pear").m_19380_();

        public MysticPear(CreativeModeTab group, ResourceLocation id, int extraVaultTicks) {
            super(group, id, extraVaultTicks);
        }

        public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
            if (!worldIn.f_46443_ && entityLiving instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entityLiving;
                if (this.onEaten(worldIn, (Player)player)) {
                    EntityHelper.changeHealth((LivingEntity)player, -MathUtilities.getRandomInt(10, 20));
                    if (MathUtilities.randomFloat(0.0f, 100.0f) <= 50.0f) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 600));
                    } else {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 600));
                    }
                    worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11767_, SoundSource.MASTER, 1.0f, 1.0f);
                } else {
                    return stack;
                }
            }
            return super.m_5922_(stack, worldIn, entityLiving);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
            tooltip.add((Component)new TextComponent(""));
            TextComponent comp = new TextComponent("A magical pear with a strange taste");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xBEEBEE)).m_131155_(Boolean.valueOf(true)));
            tooltip.add((Component)comp);
            comp = new TextComponent("It is grown on the gorgeous trees of Iskallia.");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xBEEBEE)).m_131155_(Boolean.valueOf(true)));
            tooltip.add((Component)comp);
            tooltip.add((Component)new TextComponent(""));
            comp = new TextComponent("- Wipes away 5 to 10 hearts");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
            tooltip.add((Component)comp);
            comp = new TextComponent("- Inflicts with either Wither or Poison effect");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
            tooltip.add((Component)comp);
            comp = new TextComponent("- Adds 5 minutes to the Vault Timer");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)65280)));
            tooltip.add((Component)comp);
            super.m_7373_(stack, worldIn, tooltip, flagIn);
        }
    }

    public static class SourOrange
    extends ItemVaultFruit {
        protected DamageSource damageSource = new DamageSource("sour_orange").m_19380_();

        public SourOrange(CreativeModeTab group, ResourceLocation id, int extraVaultTicks) {
            super(group, id, extraVaultTicks);
        }

        public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
            if (!worldIn.f_46443_ && entityLiving instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entityLiving;
                if (this.onEaten(worldIn, (Player)player)) {
                    EntityHelper.changeHealth((LivingEntity)player, -10);
                    worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11767_, SoundSource.MASTER, 1.0f, 1.0f);
                } else {
                    return stack;
                }
            }
            return super.m_5922_(stack, worldIn, entityLiving);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
            tooltip.add((Component)new TextComponent(""));
            TextComponent comp = new TextComponent("A magical orange with a sour taste");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xBEEBEE)).m_131155_(Boolean.valueOf(true)));
            tooltip.add((Component)comp);
            comp = new TextComponent("It is grown on the gorgeous trees of Iskallia.");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xBEEBEE)).m_131155_(Boolean.valueOf(true)));
            tooltip.add((Component)comp);
            tooltip.add((Component)new TextComponent(""));
            comp = new TextComponent("- Wipes away 5 hearts");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
            tooltip.add((Component)comp);
            comp = new TextComponent("- Adds 60 seconds to the Vault Timer");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)65280)));
            tooltip.add((Component)comp);
            super.m_7373_(stack, worldIn, tooltip, flagIn);
        }
    }

    public static class BitterLemon
    extends ItemVaultFruit {
        protected DamageSource damageSource = new DamageSource("bitter_lemon").m_19380_();

        public BitterLemon(CreativeModeTab group, ResourceLocation id, int extraVaultTicks) {
            super(group, id, extraVaultTicks);
        }

        public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
            if (!worldIn.f_46443_ && entityLiving instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entityLiving;
                if (this.onEaten(worldIn, (Player)player)) {
                    EntityHelper.changeHealth((LivingEntity)player, -6);
                    worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11767_, SoundSource.MASTER, 1.0f, 1.0f);
                } else {
                    return stack;
                }
            }
            return super.m_5922_(stack, worldIn, entityLiving);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
            tooltip.add((Component)new TextComponent(""));
            TextComponent comp = new TextComponent("A magical lemon with a bitter taste");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xBEEBEE)).m_131155_(Boolean.valueOf(true)));
            tooltip.add((Component)comp);
            comp = new TextComponent("It is grown on the gorgeous trees of Iskallia.");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xBEEBEE)).m_131155_(Boolean.valueOf(true)));
            tooltip.add((Component)comp);
            tooltip.add((Component)new TextComponent(""));
            comp = new TextComponent("- Wipes away 3 hearts");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
            tooltip.add((Component)comp);
            comp = new TextComponent("- Adds 30 seconds to the Vault Timer");
            comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)65280)));
            tooltip.add((Component)comp);
            super.m_7373_(stack, worldIn, tooltip, flagIn);
        }
    }
}

