/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.crystal.CrystalData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemVaultCrystalSeal
extends Item {
    public ItemVaultCrystalSeal(ResourceLocation id) {
        super(new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(1));
        this.setRegistryName(id);
    }

    public boolean configure(CrystalData crystal) {
        return ModConfigs.VAULT_CRYSTAL.applySeal(this, ModItems.VAULT_CRYSTAL, crystal);
    }

    @Nullable
    public static String getEventKey(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemVaultCrystalSeal)) {
            return null;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128425_("eventKey", 8)) {
            return null;
        }
        return tag.m_128461_("eventKey");
    }

    public static void setEventKey(ItemStack stack, String eventKey) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemVaultCrystalSeal)) {
            return;
        }
        stack.m_41784_().m_128359_("eventKey", eventKey);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        boolean hasEvent;
        if (world.m_5776_()) {
            return;
        }
        String eventKey = ItemVaultCrystalSeal.getEventKey(stack);
        if (eventKey == null) {
            return;
        }
        boolean bl = hasEvent = ModConfigs.ARCHITECT_EVENT.isEnabled() || ModConfigs.RAID_EVENT_CONFIG.isEnabled();
        if (!hasEvent) {
            stack.m_41764_(0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        String eventKey;
        if (!ModConfigs.isInitialized()) {
            return;
        }
        CrystalData crystal = new CrystalData();
        if (this.configure(crystal)) {
            tooltip.add((Component)new TextComponent("Sets a vault crystal's objective").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)new TextComponent("to: ").m_130940_(ChatFormatting.GRAY).m_7220_(crystal.getObjective().getName()));
        }
        if ((eventKey = ItemVaultCrystalSeal.getEventKey(stack)) != null) {
            tooltip.add((Component)new TextComponent("Event Item").m_130940_(ChatFormatting.AQUA));
            tooltip.add((Component)new TextComponent("Expires after the event finishes.").m_130940_(ChatFormatting.GRAY));
        }
    }
}

