/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.client.ClientAbilityData;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.AbilityTree;
import iskallia.vault.skill.ability.group.AbilityGroup;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemRespecFlask
extends Item {
    public ItemRespecFlask(CreativeModeTab group, ResourceLocation id) {
        super(new Item.Properties().m_41491_(group).m_41487_(2));
        this.setRegistryName(id);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (ModConfigs.ABILITIES == null) {
            return;
        }
        if (this.m_41389_(group)) {
            for (AbilityGroup<?, ?> abilityGroup : ModConfigs.ABILITIES.getAll()) {
                ItemStack stack = new ItemStack((ItemLike)this);
                ItemRespecFlask.setAbility(stack, abilityGroup.getParentName());
                items.add((Object)stack);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        String abilityStr = ItemRespecFlask.getAbility(stack);
        if (abilityStr != null) {
            AbilityGroup<?, ?> grp = ModConfigs.ABILITIES.getAbilityGroupByName(abilityStr);
            MutableComponent ability = new TextComponent(grp.getParentName()).m_130940_(ChatFormatting.GOLD);
            tooltip.add(TextComponent.f_131282_);
            tooltip.add((Component)new TextComponent("Use to remove selected specialization"));
            tooltip.add((Component)new TextComponent("of ability ").m_7220_((Component)ability));
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (ItemRespecFlask.getAbility(stack) != null) {
            return;
        }
        if (world instanceof ServerLevel && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (stack.m_41613_() > 1) {
                while (stack.m_41613_() > 1) {
                    stack.m_41774_(1);
                    ItemStack flask = new ItemStack((ItemLike)this);
                    MiscUtils.giveItem(player, flask);
                }
            }
            List<AbilityGroup<?, ?>> abilities = ModConfigs.ABILITIES.getAll();
            AbilityGroup<?, ?> group = abilities.get(world.f_46441_.nextInt(abilities.size()));
            ItemRespecFlask.setAbility(stack, group.getParentName());
        }
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    public static void setAbility(ItemStack stack, @Nullable String ability) {
        if (!(stack.m_41720_() instanceof ItemRespecFlask)) {
            return;
        }
        stack.m_41784_().m_128359_("Ability", ability);
    }

    @Nullable
    public static String getAbility(ItemStack stack) {
        if (!(stack.m_41720_() instanceof ItemRespecFlask)) {
            return null;
        }
        CompoundTag tag = stack.m_41784_();
        return tag.m_128425_("Ability", 8) ? tag.m_128461_("Ability") : null;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        String abilityStr = ItemRespecFlask.getAbility(held);
        if (abilityStr == null) {
            return InteractionResultHolder.m_19098_((Object)held);
        }
        if (world.m_5776_()) {
            if (!this.hasAbilityClient(abilityStr)) {
                return InteractionResultHolder.m_19098_((Object)held);
            }
        } else if (player instanceof ServerPlayer) {
            AbilityTree tree = PlayerAbilitiesData.get(((ServerPlayer)player).m_183503_()).getAbilities(player);
            AbilityNode<?, ?> node = tree.getNodeByName(abilityStr);
            if (!node.isLearned() || node.getSpecialization() == null) {
                return InteractionResultHolder.m_19098_((Object)held);
            }
        } else {
            return InteractionResultHolder.m_19098_((Object)held);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)held);
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean hasAbilityClient(String abilityStr) {
        AbilityNode<?, ?> node = ClientAbilityData.getLearnedAbilityNode(abilityStr);
        if (node == null) {
            return false;
        }
        return node.isLearned() && node.getSpecialization() != null;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int m_8105_(ItemStack stack) {
        return 24;
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entityLiving) {
        if (world instanceof ServerLevel) {
            ServerLevel sWorld = (ServerLevel)world;
            if (entityLiving instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entityLiving;
                String abilityStr = ItemRespecFlask.getAbility(stack);
                if (abilityStr == null) {
                    return stack;
                }
                PlayerAbilitiesData data = PlayerAbilitiesData.get(sWorld);
                AbilityNode<?, ?> node = data.getAbilities((Player)player).getNodeByName(abilityStr);
                if (node.isLearned() && node.getSpecialization() != null) {
                    data.selectSpecialization(player, node, null);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    return stack;
                }
            }
        }
        return stack;
    }
}

