/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemRelicBoosterPack
extends Item {
    public ItemRelicBoosterPack(CreativeModeTab group, ResourceLocation id) {
        super(new Item.Properties().m_41491_(group).m_41487_(64));
        this.setRegistryName(id);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_) {
            int rand = world.f_46441_.nextInt(100);
            ItemStack heldStack = player.m_21120_(hand);
            ItemStack stackToDrop = ItemStack.f_41583_;
            if (rand >= 90) {
                stackToDrop = ModConfigs.UNIDENTIFIED_RELIC_FRAGMENTS.getRandomFragment(world.f_46441_);
                ItemRelicBoosterPack.successEffects(world, player.m_20182_());
            } else {
                ItemRelicBoosterPack.failureEffects(world, player.m_20182_());
            }
            if (!stackToDrop.m_41619_()) {
                player.m_7197_(stackToDrop, false, false);
            }
            heldStack.m_41774_(1);
        }
        return super.m_7203_(world, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, world, tooltip, flagIn);
        if ("architect_event".equals(ItemRelicBoosterPack.getKey(stack))) {
            tooltip.add((Component)new TextComponent("Architect").m_130940_(ChatFormatting.AQUA));
        }
    }

    public static ItemStack getArchitectBoosterPack() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.RELIC_BOOSTER_PACK);
        stack.m_41784_().m_128359_("eventKey", "architect_event");
        return stack;
    }

    @Nullable
    public static String getKey(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        return stack.m_41784_().m_128461_("eventKey");
    }

    public static void successEffects(Level world, Vec3 pos) {
        world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, ModSounds.BOOSTER_PACK_SUCCESS_SFX, SoundSource.PLAYERS, 1.0f, 1.0f);
        ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123799_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 500, 1.0, 1.0, 1.0, 0.5);
    }

    public static void failureEffects(Level world, Vec3 pos) {
        world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, ModSounds.BOOSTER_PACK_FAIL_SFX, SoundSource.PLAYERS, 1.0f, 1.0f);
        ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 500, 1.0, 1.0, 1.0, 0.5);
    }
}

