/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.block.item.LootStatueBlockItem;
import iskallia.vault.client.gui.overlay.GiftBombOverlay;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSounds;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemGiftBomb
extends Item {
    protected Variant variant;

    public ItemGiftBomb(CreativeModeTab group, Variant variant, ResourceLocation id) {
        super(new Item.Properties().m_41491_(group).m_41487_(64));
        this.variant = variant;
        this.setRegistryName(id);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        Item heldItem = heldStack.m_41720_();
        if (heldItem instanceof ItemGiftBomb) {
            ItemGiftBomb giftBomb = (ItemGiftBomb)heldItem;
            if (!world.f_46443_) {
                ItemStack randomLoot = ModConfigs.GIFT_BOMB.randomLoot(giftBomb.variant);
                while (randomLoot.m_41613_() > 0) {
                    int amount = Math.min(randomLoot.m_41613_(), randomLoot.m_41741_());
                    ItemStack copy = randomLoot.m_41777_();
                    copy.m_41764_(amount);
                    randomLoot.m_41774_(amount);
                    player.m_7197_(copy, false, false);
                }
                heldStack.m_41774_(1);
                if (this.variant.ordinal != -1) {
                    CompoundTag nbt = Optional.ofNullable(heldStack.m_41783_()).orElse(new CompoundTag());
                    String gifter = nbt.m_128461_("Gifter");
                    ItemStack gifterStatue = LootStatueBlockItem.getStatueBlockItem(gifter);
                    player.m_7197_(gifterStatue, false, false);
                }
                Vec3 position = player.m_20182_();
                world.m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, ModSounds.GIFT_BOMB_SFX, SoundSource.PLAYERS, 0.55f, 1.0f);
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123812_, position.f_82479_, position.f_82480_, position.f_82481_, 3, 1.0, 1.0, 1.0, 0.5);
            } else {
                GiftBombOverlay.pop();
            }
        }
        return InteractionResultHolder.m_19092_((Object)heldStack, (boolean)world.m_5776_());
    }

    public Component m_7626_(ItemStack stack) {
        MutableComponent displayName = (MutableComponent)super.m_7626_(stack);
        displayName.m_6270_(Style.f_131099_.m_131148_(ItemGiftBomb.colorForVariant(this.variant)));
        return displayName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        TextColor color = ItemGiftBomb.colorForVariant(this.variant);
        if (stack.m_41782_()) {
            tooltip.add((Component)new TextComponent(""));
            CompoundTag nbt = stack.m_41783_();
            String gifter = nbt.m_128461_("Gifter");
            int giftedSubs = nbt.m_128451_("GiftedSubs");
            tooltip.add((Component)this.getPropertyInfo("Gifter", gifter, color));
            tooltip.add((Component)this.getPropertyInfo("Gifted", giftedSubs + " subscribers", color));
        }
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    private MutableComponent getPropertyInfo(String title, String value, TextColor color) {
        TextComponent titleComponent = new TextComponent(title + ": ");
        titleComponent.m_6270_(Style.f_131099_.m_131148_(color));
        TextComponent valueComponent = new TextComponent(value);
        valueComponent.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)));
        return titleComponent.m_7220_((Component)valueComponent);
    }

    private static TextColor colorForVariant(Variant variant) {
        if (variant == Variant.NORMAL) {
            return TextColor.m_131266_((int)0xBC0B0B);
        }
        if (variant == Variant.SUPER) {
            return TextColor.m_131266_((int)10423228);
        }
        if (variant == Variant.MEGA) {
            return TextColor.m_131266_((int)757692);
        }
        if (variant == Variant.OMEGA) {
            int color = (int)System.currentTimeMillis();
            return TextColor.m_131266_((int)color);
        }
        throw new InternalError("Unknown variant -> " + variant);
    }

    public static ItemStack forGift(Variant variant, String gifter, int giftedSubs) {
        ItemStack giftBomb = new ItemStack((ItemLike)ItemGiftBomb.ofVariant(variant));
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Gifter", gifter);
        nbt.m_128405_("GiftedSubs", giftedSubs);
        giftBomb.m_41751_(nbt);
        return giftBomb;
    }

    public static Item ofVariant(Variant variant) {
        return switch (variant) {
            default -> throw new IncompatibleClassChangeError();
            case Variant.NORMAL -> ModItems.NORMAL_GIFT_BOMB;
            case Variant.SUPER -> ModItems.SUPER_GIFT_BOMB;
            case Variant.MEGA -> ModItems.MEGA_GIFT_BOMB;
            case Variant.OMEGA -> ModItems.OMEGA_GIFT_BOMB;
        };
    }

    public static enum Variant {
        NORMAL(-1),
        SUPER(-1),
        MEGA(0),
        OMEGA(1);

        final int ordinal;

        private Variant(int ordinal) {
            this.ordinal = ordinal;
        }
    }
}

