/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.item;

import iskallia.vault.init.ModItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class InfiniteWaterBucketItem
extends BucketItem {
    public InfiniteWaterBucketItem(ResourceLocation id) {
        super(() -> Fluids.f_76193_, new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(1));
        this.setRegistryName(id);
    }

    public Fluid getFluid() {
        return Fluids.f_76193_;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        BlockHitResult rayTraceResult;
        ItemStack itemStack = player.m_21120_(hand);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)player, (Level)world, (ItemStack)itemStack, (HitResult)(rayTraceResult = InfiniteWaterBucketItem.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE)));
        if (ret != null) {
            return ret;
        }
        if (rayTraceResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        BlockPos pos = rayTraceResult.m_82425_();
        Direction direction = rayTraceResult.m_82434_();
        if (world.m_7966_(player, pos) && player.m_36204_(pos, direction, itemStack)) {
            BlockState state = world.m_8055_(pos);
            if (state.m_60713_(Blocks.f_50256_)) {
                int cauldronLevel = (Integer)state.m_61143_((Property)BlockStateProperties.f_61418_);
                if (cauldronLevel < 3) {
                    player.m_36220_(Stats.f_12943_);
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61418_, (Comparable)Integer.valueOf(3)), 3);
                    world.m_46717_(pos, state.m_60734_());
                    world.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResultHolder.m_19090_((Object)itemStack);
            }
            InteractionResultHolder result = super.m_7203_(world, player, hand);
            if (result.m_19089_() == InteractionResult.SUCCESS || result.m_19089_() == InteractionResult.CONSUME) {
                return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)world.m_5776_());
            }
            return result;
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return new ItemStack((ItemLike)ModItems.INFINITE_WATER_BUCKET);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new InfiniteWaterBucketHandler(stack);
    }

    public static class InfiniteWaterBucketHandler
    implements IFluidHandlerItem,
    ICapabilityProvider {
        private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
        protected ItemStack container;

        public InfiniteWaterBucketHandler(@Nonnull ItemStack container) {
            this.container = container;
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.container;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return new FluidStack((Fluid)Fluids.f_76193_, 1000);
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.isEmpty() || resource.getFluid() != Fluids.f_76193_) {
                return FluidStack.EMPTY;
            }
            return new FluidStack((Fluid)Fluids.f_76193_, resource.getAmount());
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return new FluidStack((Fluid)Fluids.f_76193_, maxDrain);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(cap, this.holder);
        }
    }
}

